/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontConfigManager$FontConfigFont;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

class FontConfigManager$EmbeddedFontSupport {
    private static String fontDirProp = null;
    private static String fontDir;
    private static boolean fontDirFromJRE;
    static String[] jreFontsProperties;

    private FontConfigManager$EmbeddedFontSupport() {
    }

    private static void initEmbeddedFonts() {
        fontDirProp = System.getProperty("prism.fontdir");
        if (fontDirProp != null) {
            fontDir = fontDirProp;
        } else {
            try {
                String string = System.getProperty("java.home");
                if (string == null) {
                    return;
                }
                File file = new File(string, "lib/fonts");
                if (file.exists()) {
                    fontDirFromJRE = true;
                    fontDir = file.getPath();
                }
                if (FontConfigManager.debugFonts) {
                    System.err.println("Fallback fontDir is " + file + " exists = " + file.exists());
                }
            }
            catch (Exception exception) {
                if (FontConfigManager.debugFonts) {
                    exception.printStackTrace();
                }
                fontDir = "/";
            }
        }
    }

    private static String getStyleStr(int n2) {
        switch (n2) {
            case 0: {
                return "regular";
            }
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "regular";
    }

    private static boolean exists(File file) {
        return AccessController.doPrivileged(() -> file.exists());
    }

    static void initLogicalFonts(FontConfigManager$FcCompFont[] fontConfigManager$FcCompFontArray) {
        Object object;
        Properties properties;
        block11: {
            properties = new Properties();
            try {
                File file = new File(fontDir, "logicalfonts.properties");
                if (file.exists()) {
                    object = new FileInputStream(file);
                    properties.load((InputStream)object);
                    ((FileInputStream)object).close();
                } else if (fontDirFromJRE) {
                    for (int i2 = 0; i2 < jreFontsProperties.length; i2 += 2) {
                        properties.setProperty(jreFontsProperties[i2], jreFontsProperties[i2 + 1]);
                    }
                    if (FontConfigManager.debugFonts) {
                        System.err.println("Using fallback implied logicalfonts.properties");
                    }
                }
            }
            catch (IOException iOException) {
                if (!FontConfigManager.debugFonts) break block11;
                System.err.println(iOException);
                return;
            }
        }
        for (int i3 = 0; i3 < fontConfigManager$FcCompFontArray.length; ++i3) {
            object = fontConfigManager$FcCompFontArray[i3].fcFamily;
            String string = FontConfigManager$EmbeddedFontSupport.getStyleStr(fontConfigManager$FcCompFontArray[i3].style);
            String string2 = (String)object + "." + string + ".";
            ArrayList<FontConfigManager$FontConfigFont> arrayList = new ArrayList<FontConfigManager$FontConfigFont>();
            int n2 = 0;
            while (true) {
                String string3 = properties.getProperty(string2 + n2 + ".file");
                String string4 = properties.getProperty(string2 + n2 + ".font");
                ++n2;
                if (string3 == null) break;
                File file = new File(fontDir, string3);
                if (!FontConfigManager$EmbeddedFontSupport.exists(file)) {
                    if (!FontConfigManager.debugFonts) continue;
                    System.out.println("Failed to find logical font file " + file);
                    continue;
                }
                FontConfigManager$FontConfigFont fontConfigManager$FontConfigFont = new FontConfigManager$FontConfigFont();
                fontConfigManager$FontConfigFont.fontFile = file.getPath();
                fontConfigManager$FontConfigFont.fullName = string4;
                fontConfigManager$FontConfigFont.familyName = null;
                fontConfigManager$FontConfigFont.styleStr = null;
                if (fontConfigManager$FcCompFontArray[i3].firstFont == null) {
                    fontConfigManager$FcCompFontArray[i3].firstFont = fontConfigManager$FontConfigFont;
                }
                arrayList.add(fontConfigManager$FontConfigFont);
            }
            if (arrayList.size() <= 0) continue;
            fontConfigManager$FcCompFontArray[i3].allFonts = new FontConfigManager$FontConfigFont[arrayList.size()];
            arrayList.toArray(fontConfigManager$FcCompFontArray[i3].allFonts);
        }
    }

    static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        Properties properties = new Properties();
        Void void_ = AccessController.doPrivileged(() -> {
            block2: {
                try {
                    String string = fontDir + "/allfonts.properties";
                    FileInputStream fileInputStream = new FileInputStream(string);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    properties.clear();
                    if (!FontConfigManager.debugFonts) break block2;
                    System.err.println(iOException);
                    System.err.println("Fall back to opening the files");
                }
            }
            return null;
        });
        if (!properties.isEmpty()) {
            int n2 = Integer.MAX_VALUE;
            try {
                n2 = Integer.parseInt(properties.getProperty("maxFont", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0) {
                n2 = Integer.MAX_VALUE;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = properties.getProperty("family." + i2);
                String string2 = properties.getProperty("font." + i2);
                String string3 = properties.getProperty("file." + i2);
                if (string3 == null) break;
                File file = new File(fontDir, string3);
                if (!FontConfigManager$EmbeddedFontSupport.exists(file) || string == null || string2 == null) continue;
                String string4 = string2.toLowerCase(Locale.ENGLISH);
                String string5 = string.toLowerCase(Locale.ENGLISH);
                hashMap.put(string4, file.getPath());
                hashMap2.put(string4, string);
                ArrayList<String> arrayList = hashMap3.get(string5);
                if (arrayList == null) {
                    arrayList = new ArrayList(4);
                    hashMap3.put(string5, arrayList);
                }
                arrayList.add(string2);
            }
        }
    }

    static {
        fontDirFromJRE = false;
        Void void_ = AccessController.doPrivileged(() -> {
            FontConfigManager$EmbeddedFontSupport.initEmbeddedFonts();
            return null;
        });
        jreFontsProperties = new String[]{"sans.regular.0.font", "Lucida Sans Regular", "sans.regular.0.file", "LucidaSansRegular.ttf", "sans.bold.0.font", "Lucida Sans Bold", "sans.bold.0.file", "LucidaSansDemiBold.ttf", "monospace.regular.0.font", "Lucida Typewriter Regular", "monospace.regular.0.file", "LucidaTypewriterRegular.ttf", "monospace.bold.0.font", "Lucida Typewriter Bold", "monospace.bold.0.file", "LucidaTypewriterBold.ttf", "serif.regular.0.font", "Lucida Bright", "serif.regular.0.file", "LucidaBrightRegular.ttf", "serif.bold.0.font", "Lucida Bright Demibold", "serif.bold.0.file", "LucidaBrightDemiBold.ttf", "serif.italic.0.font", "Lucida Bright Italic", "serif.italic.0.file", "LucidaBrightItalic.ttf", "serif.bolditalic.0.font", "Lucida Bright Demibold Italic", "serif.bolditalic.0.file", "LucidaBrightDemiItalic.ttf"};
    }
}

