/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.font.AndroidFontFinder$1;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

class AndroidFontFinder {
    private static final String SYSTEM_FONT_NAME = "sans serif";
    private static final float SYSTEM_FONT_SIZE = 16.0f;
    static final String fontDescriptor_2_X_Path = "/com/sun/javafx/font/android_system_fonts.xml";
    static final String fontDescriptor_4_X_Path = "/system/etc/system_fonts.xml";
    static final String systemFontsDir = "/system/fonts";

    AndroidFontFinder() {
    }

    public static String getSystemFont() {
        return SYSTEM_FONT_NAME;
    }

    public static float getSystemFontSize() {
        return 16.0f;
    }

    public static String getSystemFontsDir() {
        return systemFontsDir;
    }

    private static boolean parse_2_X_SystemDefaultFonts(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        InputStream inputStream = AndroidFontFinder.class.getResourceAsStream(fontDescriptor_2_X_Path);
        if (inputStream == null) {
            System.err.println("Resource not found: /com/sun/javafx/font/android_system_fonts.xml");
            return false;
        }
        return AndroidFontFinder.parseSystemDefaultFonts(inputStream, hashMap, hashMap2, hashMap3);
    }

    private static boolean parse_4_X_SystemDefaultFonts(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        File file = new File(fontDescriptor_4_X_Path);
        try {
            return AndroidFontFinder.parseSystemDefaultFonts(new FileInputStream(file), hashMap, hashMap2, hashMap3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: /system/etc/system_fonts.xml");
            return false;
        }
    }

    private static boolean parseSystemDefaultFonts(InputStream inputStream, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            AndroidFontFinder$1 androidFontFinder$1 = new AndroidFontFinder$1(hashMap, hashMap2, hashMap3);
            sAXParser.parse(inputStream, (DefaultHandler)androidFontFinder$1);
            return true;
        }
        catch (IOException iOException) {
            System.err.println("Failed to load default fonts descriptor: /system/etc/system_fonts.xml");
        }
        catch (Exception exception) {
            System.err.println("Failed parsing default fonts descriptor;");
            exception.printStackTrace();
        }
        return false;
    }

    public static void populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        boolean bl2;
        if (hashMap == null || hashMap2 == null || hashMap3 == null) {
            return;
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        if (!(bl2 = AndroidFontFinder.parse_4_X_SystemDefaultFonts(hashMap, hashMap2, hashMap3))) {
            AndroidFontFinder.parse_2_X_SystemDefaultFonts(hashMap, hashMap2, hashMap3);
        }
    }

    static {
        Void void_ = AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_font");
            return null;
        });
    }
}

