/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import dev.protect.wT;
import dev.protect.wU;
import dev.protect.wV;

public class EventDispatchChainImpl
implements wU {
    private static final int CAPACITY_GROWTH_FACTOR = 8;
    private wV[] dispatchers;
    private int[] nextLinks;
    private int reservedCount;
    private int activeCount;
    private int headIndex;
    private int tailIndex;

    public void reset() {
        for (int i2 = 0; i2 < this.reservedCount; ++i2) {
            this.dispatchers[i2] = null;
        }
        this.reservedCount = 0;
        this.activeCount = 0;
        this.headIndex = 0;
        this.tailIndex = 0;
    }

    @Override
    public wU append(wV wV2) {
        this.ensureCapacity(this.reservedCount + 1);
        if (this.activeCount == 0) {
            this.insertFirst(wV2);
            return this;
        }
        this.dispatchers[this.reservedCount] = wV2;
        this.nextLinks[this.tailIndex] = this.reservedCount;
        this.tailIndex = this.reservedCount++;
        ++this.activeCount;
        return this;
    }

    @Override
    public wU prepend(wV wV2) {
        this.ensureCapacity(this.reservedCount + 1);
        if (this.activeCount == 0) {
            this.insertFirst(wV2);
            return this;
        }
        this.dispatchers[this.reservedCount] = wV2;
        this.nextLinks[this.reservedCount] = this.headIndex;
        this.headIndex = this.reservedCount++;
        ++this.activeCount;
        return this;
    }

    @Override
    public wT dispatchEvent(wT wT2) {
        if (this.activeCount == 0) {
            return wT2;
        }
        int n2 = this.headIndex;
        int n3 = this.tailIndex;
        int n4 = this.activeCount--;
        int n5 = this.reservedCount;
        wV wV2 = this.dispatchers[this.headIndex];
        this.headIndex = this.nextLinks[this.headIndex];
        wT wT3 = wV2.dispatchEvent(wT2, this);
        this.headIndex = n2;
        this.tailIndex = n3;
        this.activeCount = n4;
        this.reservedCount = n5;
        return wT3;
    }

    private void insertFirst(wV wV2) {
        this.dispatchers[this.reservedCount] = wV2;
        this.headIndex = this.reservedCount;
        this.tailIndex = this.reservedCount++;
        this.activeCount = 1;
    }

    private void ensureCapacity(int n2) {
        int n3 = n2 + 8 - 1 & 0xFFFFFFF8;
        if (n3 == 0) {
            return;
        }
        if (this.dispatchers == null || this.dispatchers.length < n3) {
            wV[] wVArray = new wV[n3];
            int[] nArray = new int[n3];
            if (this.reservedCount > 0) {
                System.arraycopy(this.dispatchers, 0, wVArray, 0, this.reservedCount);
                System.arraycopy(this.nextLinks, 0, nArray, 0, this.reservedCount);
            }
            this.dispatchers = wVArray;
            this.nextLinks = nArray;
        }
    }
}

