/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import com.sun.javafx.embed.swing.SwingNodeHelper$SwingNodeAccessor;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import dev.protect.po;
import dev.protect.wK;
import dev.protect.yD;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;

public class SwingNodeHelper
extends NodeHelper {
    private static final SwingNodeHelper theInstance = new SwingNodeHelper();
    private static SwingNodeHelper$SwingNodeAccessor swingNodeAccessor;
    private static final Set<Object> eventLoopKeys;

    private static SwingNodeHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(wK wK2) {
        SwingNodeHelper.setHelper(wK2, SwingNodeHelper.getInstance());
    }

    @Override
    protected NGNode createPeerImpl(yD yD2) {
        return swingNodeAccessor.doCreatePeer(yD2);
    }

    @Override
    protected void updatePeerImpl(yD yD2) {
        super.updatePeerImpl(yD2);
        swingNodeAccessor.doUpdatePeer(yD2);
    }

    @Override
    protected BaseBounds computeGeomBoundsImpl(yD yD2, BaseBounds baseBounds, BaseTransform baseTransform) {
        return swingNodeAccessor.doComputeGeomBounds(yD2, baseBounds, baseTransform);
    }

    @Override
    protected boolean computeContainsImpl(yD yD2, double d2, double d3) {
        return swingNodeAccessor.doComputeContains(yD2, d2, d3);
    }

    public static Object getLightweightFrame(wK wK2) {
        return swingNodeAccessor.getLightweightFrame(wK2);
    }

    public static ReentrantLock getPaintLock(wK wK2) {
        return swingNodeAccessor.getPaintLock(wK2);
    }

    public static void setImageBuffer(wK wK2, int[] nArray, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
        swingNodeAccessor.setImageBuffer(wK2, nArray, n2, n3, n4, n5, n6, d2, d3);
    }

    public static void setImageBounds(wK wK2, int n2, int n3, int n4, int n5) {
        swingNodeAccessor.setImageBounds(wK2, n2, n3, n4, n5);
    }

    public static void repaintDirtyRegion(wK wK2, int n2, int n3, int n4, int n5) {
        swingNodeAccessor.repaintDirtyRegion(wK2, n2, n3, n4, n5);
    }

    public static void ungrabFocus(wK wK2, boolean bl2) {
        swingNodeAccessor.ungrabFocus(wK2, bl2);
    }

    public static void setSwingPrefWidth(wK wK2, int n2) {
        swingNodeAccessor.setSwingPrefWidth(wK2, n2);
    }

    public static void setSwingPrefHeight(wK wK2, int n2) {
        swingNodeAccessor.setSwingPrefHeight(wK2, n2);
    }

    public static void setSwingMaxWidth(wK wK2, int n2) {
        swingNodeAccessor.setSwingMaxWidth(wK2, n2);
    }

    public static void setSwingMaxHeight(wK wK2, int n2) {
        swingNodeAccessor.setSwingMaxHeight(wK2, n2);
    }

    public static void setSwingMinWidth(wK wK2, int n2) {
        swingNodeAccessor.setSwingMinWidth(wK2, n2);
    }

    public static void setSwingMinHeight(wK wK2, int n2) {
        swingNodeAccessor.setSwingMinHeight(wK2, n2);
    }

    public static void setGrabbed(wK wK2, boolean bl2) {
        swingNodeAccessor.setGrabbed(wK2, bl2);
    }

    public static void runOnFxThread(Runnable runnable) {
        if (po.isFxApplicationThread()) {
            runnable.run();
        } else {
            po.runLater(runnable);
        }
    }

    public static void runOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runOnEDTAndWait(Object object, Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            eventLoopKeys.add(object);
            SwingUtilities.invokeLater(runnable);
            Toolkit.getToolkit().enterNestedEventLoop(object);
        }
    }

    public static void leaveFXNestedLoop(Object object) {
        if (!eventLoopKeys.contains(object)) {
            return;
        }
        if (po.isFxApplicationThread()) {
            Toolkit.getToolkit().exitNestedEventLoop(object, null);
        } else {
            po.runLater(() -> Toolkit.getToolkit().exitNestedEventLoop(object, null));
        }
        eventLoopKeys.remove(object);
    }

    public static void setSwingNodeAccessor(SwingNodeHelper$SwingNodeAccessor swingNodeHelper$SwingNodeAccessor) {
        if (swingNodeAccessor != null) {
            throw new IllegalStateException();
        }
        swingNodeAccessor = swingNodeHelper$SwingNodeAccessor;
    }

    static {
        Utils.forceInit(wK.class);
        eventLoopKeys = new HashSet<Object>();
    }
}

