/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.swing.SwingDnD$1;
import com.sun.javafx.embed.swing.SwingDnD$1StubDragGestureRecognizer;
import com.sun.javafx.embed.swing.SwingDnD$2;
import com.sun.javafx.embed.swing.SwingDnD$3;
import com.sun.javafx.embed.swing.SwingDnD$DnDTransferable;
import com.sun.javafx.embed.swing.SwingDragSource;
import com.sun.javafx.tk.Toolkit;
import dev.protect.Sl;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class SwingDnD {
    private final Transferable dndTransferable = new SwingDnD$DnDTransferable(this);
    private final DragSource dragSource;
    private final DragSourceListener dragSourceListener;
    private SwingDragSource swingDragSource;
    private EmbeddedSceneDTInterface fxDropTarget;
    private EmbeddedSceneDSInterface fxDragSource;
    private MouseEvent me;

    public SwingDnD(JComponent jComponent, EmbeddedSceneInterface embeddedSceneInterface) {
        jComponent.addMouseListener(new SwingDnD$1(this));
        this.dragSource = new DragSource();
        this.dragSourceListener = new SwingDnD$2(this);
        SwingDnD$3 swingDnD$3 = new SwingDnD$3(this, embeddedSceneInterface, jComponent);
        jComponent.setDropTarget(new DropTarget(jComponent, 0x40000003, swingDnD$3));
    }

    public void addNotify() {
        this.dragSource.addDragSourceListener(this.dragSourceListener);
    }

    public void removeNotify() {
        this.dragSource.removeDragSourceListener(this.dragSourceListener);
    }

    public HostDragStartListener getDragStartListener() {
        return (embeddedSceneDSInterface, sl2) -> {
            assert (Toolkit.getToolkit().isFxUserThread());
            assert (embeddedSceneDSInterface != null);
            SwingUtilities.invokeLater(() -> {
                assert (this.fxDragSource == null);
                assert (this.swingDragSource == null);
                assert (this.fxDropTarget == null);
                this.fxDragSource = embeddedSceneDSInterface;
                this.startDrag(this.me, this.dndTransferable, embeddedSceneDSInterface.getSupportedActions(), sl2);
            });
        };
    }

    private void startDrag(MouseEvent mouseEvent, Transferable transferable, Set<Sl> set, Sl sl2) {
        assert (set.contains((Object)sl2));
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n2 = SwingDnD.transferModeToDropAction(sl2);
        SwingDnD$1StubDragGestureRecognizer swingDnD$1StubDragGestureRecognizer = new SwingDnD$1StubDragGestureRecognizer(this, this.dragSource, mouseEvent, set);
        List<InputEvent> list = Arrays.asList(swingDnD$1StubDragGestureRecognizer.getTriggerEvent());
        DragGestureEvent dragGestureEvent = new DragGestureEvent(swingDnD$1StubDragGestureRecognizer, n2, point, list);
        dragGestureEvent.startDrag(null, transferable);
    }

    private void endDnD() {
        assert (this.swingDragSource != null);
        assert (this.fxDropTarget != null);
        this.fxDropTarget = null;
        this.swingDragSource = null;
    }

    private void storeMouseEvent(MouseEvent mouseEvent) {
        this.me = mouseEvent;
    }

    private void applyDragResult(Sl sl2, DropTargetDragEvent dropTargetDragEvent) {
        if (sl2 == null) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(SwingDnD.transferModeToDropAction(sl2));
        }
    }

    private void applyDropResult(Sl sl2, DropTargetDropEvent dropTargetDropEvent) {
        if (sl2 == null) {
            dropTargetDropEvent.rejectDrop();
        } else {
            dropTargetDropEvent.acceptDrop(SwingDnD.transferModeToDropAction(sl2));
        }
    }

    public static Sl dropActionToTransferMode(int n2) {
        switch (n2) {
            case 1: {
                return Sl.b;
            }
            case 2: {
                return Sl.c;
            }
            case 0x40000000: {
                return Sl.d;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int transferModeToDropAction(Sl sl2) {
        switch (sl2) {
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 0x40000000;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Set<Sl> dropActionsToTransferModes(int n2) {
        EnumSet<Sl> enumSet = EnumSet.noneOf(Sl.class);
        if ((n2 & 1) != 0) {
            enumSet.add(Sl.b);
        }
        if ((n2 & 2) != 0) {
            enumSet.add(Sl.c);
        }
        if ((n2 & 0x40000000) != 0) {
            enumSet.add(Sl.d);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public static int transferModesToDropActions(Set<Sl> set) {
        int n2 = 0;
        for (Sl sl2 : set) {
            n2 |= SwingDnD.transferModeToDropAction(sl2);
        }
        return n2;
    }
}

