/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.BitSet;
import dev.protect.vv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class StyleClassSet
extends BitSet<vv> {
    static final Map<String, Integer> styleClassMap = new HashMap<String, Integer>(64);
    static final List<vv> styleClasses = new ArrayList<vv>();

    public StyleClassSet() {
    }

    StyleClassSet(List<String> list) {
        int n2 = list != null ? list.size() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            if (string == null || string.isEmpty()) continue;
            vv vv2 = StyleClassSet.getStyleClass(string);
            this.add(vv2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new vv[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = new vv[this.size()];
        }
        int n2 = 0;
        while (n2 < this.getBits().length) {
            long l2 = this.getBits()[n2];
            for (int i2 = 0; i2 < 64; ++i2) {
                long l3 = 1L << i2;
                if ((l2 & l3) != l3) continue;
                int n3 = n2 * 64 + i2;
                vv vv2 = StyleClassSet.getStyleClass(n3);
                objectArray[n2++] = vv2;
            }
        }
        return objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("style-classes: [");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((vv)iterator.next()).ag());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    protected vv cast(Object object) {
        if (object == null) {
            throw new NullPointerException("null arg");
        }
        vv vv2 = (vv)object;
        return vv2;
    }

    @Override
    protected vv getT(int n2) {
        return StyleClassSet.getStyleClass(n2);
    }

    @Override
    protected int getIndex(vv vv2) {
        return vv2.getIndex();
    }

    public static vv getStyleClass(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("styleClass cannot be null or empty String");
        }
        vv vv2 = null;
        Integer n2 = styleClassMap.get(string);
        int n3 = n2 != null ? n2 : -1;
        int n4 = styleClasses.size();
        assert (n3 < n4);
        if (n3 != -1 && n3 < n4) {
            vv2 = styleClasses.get(n3);
        }
        if (vv2 == null) {
            vv2 = new vv(string, n4);
            styleClasses.add(vv2);
            styleClassMap.put(string, n4);
        }
        return vv2;
    }

    static vv getStyleClass(int n2) {
        if (0 <= n2 && n2 < styleClasses.size()) {
            return styleClasses.get(n2);
        }
        return null;
    }
}

