/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.collections.SetListenerHelper;
import com.sun.javafx.css.BitSet$1;
import com.sun.javafx.css.BitSet$Change;
import dev.protect.pv;
import dev.protect.tP;
import dev.protect.tQ;
import java.util.Collection;
import java.util.Iterator;

abstract class BitSet<T>
implements tP<T> {
    private static final long[] EMPTY_SET = new long[0];
    private long[] bits = EMPTY_SET;
    private SetListenerHelper<T> listenerHelper;

    protected BitSet() {
    }

    @Override
    public int size() {
        int n2 = 0;
        if (this.bits.length > 0) {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                long l2 = this.bits[i2];
                if (l2 == 0L) continue;
                n2 += Long.bitCount(l2);
            }
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        if (this.bits.length > 0) {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                long l2 = this.bits[i2];
                if (l2 == 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new BitSet$1(this);
    }

    @Override
    public boolean add(T t2) {
        boolean bl2;
        if (t2 == null) {
            return false;
        }
        int n2 = this.getIndex(t2) / 64;
        long l2 = 1L << this.getIndex(t2) % 64;
        if (n2 >= this.bits.length) {
            long[] lArray = new long[n2 + 1];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
        long l3 = this.bits[n2];
        this.bits[n2] = l3 | l2;
        boolean bl3 = bl2 = this.bits[n2] != l3;
        if (bl2 && SetListenerHelper.hasListeners(this.listenerHelper)) {
            this.notifyObservers(t2, false);
        }
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl2;
        if (object == null) {
            return false;
        }
        T t2 = this.cast(object);
        int n2 = this.getIndex(t2) / 64;
        long l2 = 1L << this.getIndex(t2) % 64;
        if (n2 >= this.bits.length) {
            return false;
        }
        long l3 = this.bits[n2];
        this.bits[n2] = l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl3 = bl2 = this.bits[n2] != l3;
        if (bl2) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                this.notifyObservers(t2, true);
            }
            boolean bl4 = true;
            for (int i2 = 0; i2 < this.bits.length && bl4; bl4 &= this.bits[i2] == 0L, ++i2) {
            }
            if (bl4) {
                this.bits = EMPTY_SET;
            }
        }
        return bl2;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        T t2 = this.cast(object);
        int n2 = this.getIndex(t2) / 64;
        long l2 = 1L << this.getIndex(t2) % 64;
        return n2 < this.bits.length && (this.bits[n2] & l2) == l2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == null || this.getClass() != collection.getClass()) {
            return false;
        }
        BitSet bitSet = (BitSet)collection;
        if (this.bits.length == 0 && bitSet.bits.length == 0) {
            return true;
        }
        if (this.bits.length < bitSet.bits.length) {
            return false;
        }
        int n2 = bitSet.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((this.bits[i2] & bitSet.bits[i2]) == bitSet.bits[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n2;
        if (collection == null || this.getClass() != collection.getClass()) {
            return false;
        }
        boolean bl2 = false;
        BitSet bitSet = (BitSet)collection;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        long[] lArray2 = bitSet.bits;
        int n4 = lArray2.length;
        int n5 = n3 < n4 ? n4 : n3;
        long[] lArray3 = n5 > 0 ? new long[n5] : EMPTY_SET;
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 < lArray.length && n2 < lArray2.length) {
                lArray3[n2] = lArray[n2] | lArray2[n2];
                bl2 |= lArray3[n2] != lArray[n2];
                continue;
            }
            if (n2 < lArray.length) {
                lArray3[n2] = lArray[n2];
                bl2 |= false;
                continue;
            }
            lArray3[n2] = lArray2[n2];
            bl2 = true;
        }
        if (bl2) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < n5; ++n2) {
                    long l2 = 0L;
                    if (n2 < lArray.length && n2 < lArray2.length) {
                        l2 = (lArray[n2] ^ 0xFFFFFFFFFFFFFFFFL) & lArray2[n2];
                    } else {
                        if (n2 < lArray.length) continue;
                        l2 = lArray2[n2];
                    }
                    for (int i2 = 0; i2 < 64; ++i2) {
                        long l3 = 1L << i2;
                        if ((l3 & l2) != l3) continue;
                        T t2 = this.getT(n2 * 64 + i2);
                        this.notifyObservers(t2, false);
                    }
                }
            }
            this.bits = lArray3;
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int n2;
        if (collection == null || this.getClass() != collection.getClass()) {
            this.clear();
            return true;
        }
        boolean bl2 = false;
        BitSet bitSet = (BitSet)collection;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        long[] lArray2 = bitSet.bits;
        int n4 = lArray2.length;
        int n5 = n3 < n4 ? n3 : n4;
        long[] lArray3 = n5 > 0 ? new long[n5] : EMPTY_SET;
        bl2 |= lArray.length > n5;
        boolean bl3 = true;
        for (n2 = 0; n2 < n5; ++n2) {
            lArray3[n2] = lArray[n2] & lArray2[n2];
            bl2 |= lArray3[n2] != lArray[n2];
            bl3 &= lArray3[n2] == 0L;
        }
        if (bl2) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    long l2 = 0L;
                    l2 = n2 < lArray2.length ? lArray[n2] & (lArray2[n2] ^ 0xFFFFFFFFFFFFFFFFL) : lArray[n2];
                    for (int i2 = 0; i2 < 64; ++i2) {
                        long l3 = 1L << i2;
                        if ((l3 & l2) != l3) continue;
                        T t2 = this.getT(n2 * 64 + i2);
                        this.notifyObservers(t2, true);
                    }
                }
            }
            this.bits = !bl3 ? lArray3 : EMPTY_SET;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n2;
        if (collection == null || this.getClass() != collection.getClass()) {
            return false;
        }
        boolean bl2 = false;
        BitSet bitSet = (BitSet)collection;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        long[] lArray2 = bitSet.bits;
        int n4 = lArray2.length;
        int n5 = n3 < n4 ? n3 : n4;
        long[] lArray3 = n5 > 0 ? new long[n5] : EMPTY_SET;
        boolean bl3 = true;
        for (n2 = 0; n2 < n5; ++n2) {
            lArray3[n2] = lArray[n2] & (lArray2[n2] ^ 0xFFFFFFFFFFFFFFFFL);
            bl2 |= lArray3[n2] != lArray[n2];
            bl3 &= lArray3[n2] == 0L;
        }
        if (bl2) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < n5; ++n2) {
                    long l2 = lArray[n2] & lArray2[n2];
                    for (int i2 = 0; i2 < 64; ++i2) {
                        long l3 = 1L << i2;
                        if ((l3 & l2) != l3) continue;
                        T t2 = this.getT(n2 * 64 + i2);
                        this.notifyObservers(t2, true);
                    }
                }
            }
            this.bits = !bl3 ? lArray3 : EMPTY_SET;
        }
        return bl2;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            long l2 = this.bits[i2];
            for (int i3 = 0; i3 < 64; ++i3) {
                long l3 = 1L << i3;
                if ((l3 & l2) != l3) continue;
                T t2 = this.getT(i2 * 64 + i3);
                this.notifyObservers(t2, true);
            }
        }
        this.bits = EMPTY_SET;
    }

    @Override
    public int hashCode() {
        int n2 = 7;
        if (this.bits.length > 0) {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                long l2 = this.bits[i2];
                n2 = 71 * n2 + (int)(l2 ^ l2 >>> 32);
            }
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        int n2;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BitSet bitSet = (BitSet)object;
        int n3 = this.bits != null ? this.bits.length : 0;
        int n4 = n2 = bitSet.bits != null ? bitSet.bits.length : 0;
        if (n3 != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = this.bits[i2];
            long l3 = bitSet.bits[i2];
            if (l2 == l3) continue;
            return false;
        }
        return true;
    }

    protected abstract T getT(int var1);

    protected abstract int getIndex(T var1);

    protected abstract T cast(Object var1);

    protected long[] getBits() {
        return this.bits;
    }

    @Override
    public void addListener(tQ<? super T> tQ2) {
        if (tQ2 != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, tQ2);
        }
    }

    @Override
    public void removeListener(tQ<? super T> tQ2) {
        if (tQ2 != null) {
            SetListenerHelper.removeListener(this.listenerHelper, tQ2);
        }
    }

    @Override
    public void addListener(pv pv2) {
        if (pv2 != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, pv2);
        }
    }

    @Override
    public void removeListener(pv pv2) {
        if (pv2 != null) {
            SetListenerHelper.removeListener(this.listenerHelper, pv2);
        }
    }

    private void notifyObservers(T t2, boolean bl2) {
        if (t2 != null && SetListenerHelper.hasListeners(this.listenerHelper)) {
            BitSet$Change bitSet$Change = new BitSet$Change(this, t2, bl2);
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, bitSet$Change);
        }
    }
}

