/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ListListenerHelper;
import com.sun.javafx.collections.SourceAdapterChange;
import com.sun.javafx.collections.VetoableListDecorator$ModCountAccessor;
import com.sun.javafx.collections.VetoableListDecorator$ModCountAccessorImpl;
import com.sun.javafx.collections.VetoableListDecorator$VetoableIteratorDecorator;
import com.sun.javafx.collections.VetoableListDecorator$VetoableListIteratorDecorator;
import com.sun.javafx.collections.VetoableListDecorator$VetoableSubListDecorator;
import dev.protect.pv;
import dev.protect.tC;
import dev.protect.tD;
import dev.protect.tM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class VetoableListDecorator<E>
implements tM<E> {
    private final tM<E> list;
    private int modCount;
    private ListListenerHelper<E> helper;

    protected abstract void onProposedChange(List<E> var1, int ... var2);

    public VetoableListDecorator(tM<E> tM2) {
        this.list = tM2;
        this.list.addListener((tD<? super E> tD2) -> ListListenerHelper.fireValueChangedEvent(this.helper, new SourceAdapterChange(this, tD2)));
    }

    @Override
    public void addListener(tC<? super E> tC2) {
        this.helper = ListListenerHelper.addListener(this.helper, tC2);
    }

    @Override
    public void removeListener(tC<? super E> tC2) {
        this.helper = ListListenerHelper.removeListener(this.helper, tC2);
    }

    @Override
    public void addListener(pv pv2) {
        this.helper = ListListenerHelper.addListener(this.helper, pv2);
    }

    @Override
    public void removeListener(pv pv2) {
        this.helper = ListListenerHelper.removeListener(this.helper, pv2);
    }

    @Override
    public boolean addAll(E ... EArray) {
        return this.addAll((Collection<? extends E>)Arrays.asList(EArray));
    }

    @Override
    public boolean setAll(E ... EArray) {
        return this.setAll((Collection<? extends E>)Arrays.asList(EArray));
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(collection)), 0, this.size());
        try {
            ++this.modCount;
            return this.list.setAll(collection);
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    private void removeFromList(List<E> list, int n2, Collection<?> collection, boolean bl2) {
        int[] nArray = new int[2];
        int n3 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            E e2 = list.get(i2);
            if (!(collection.contains(e2) ^ bl2)) continue;
            if (n3 == -1) {
                nArray[n3 + 1] = n2 + i2;
                nArray[n3 + 2] = n2 + i2 + 1;
                n3 += 2;
                continue;
            }
            if (nArray[n3 - 1] == n2 + i2) {
                nArray[n3 - 1] = n2 + i2 + 1;
                continue;
            }
            int[] nArray2 = new int[nArray.length + 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            nArray[n3 + 1] = n2 + i2;
            nArray[n3 + 2] = n2 + i2 + 1;
            n3 += 2;
        }
        if (n3 != -1) {
            this.onProposedChange(Collections.emptyList(), nArray);
        }
    }

    @Override
    public boolean removeAll(E ... EArray) {
        return this.removeAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public boolean retainAll(E ... EArray) {
        return this.retainAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public void remove(int n2, int n3) {
        this.onProposedChange(Collections.emptyList(), n2, n3);
        try {
            ++this.modCount;
            this.list.remove(n2, n3);
        }
        catch (Exception exception) {
            --this.modCount;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new VetoableListDecorator$VetoableIteratorDecorator(this, new VetoableListDecorator$ModCountAccessorImpl(this), this.list.iterator(), 0);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        this.onProposedChange(Collections.singletonList(e2), this.size(), this.size());
        try {
            ++this.modCount;
            this.list.add(e2);
            return true;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.list.indexOf(object);
        if (n2 != -1) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(collection)), this.size(), this.size());
        try {
            ++this.modCount;
            boolean bl2 = this.list.addAll(collection);
            if (!bl2) {
                --this.modCount;
            }
            return bl2;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(collection)), n2, n2);
        try {
            ++this.modCount;
            boolean bl2 = this.list.addAll(n2, collection);
            if (!bl2) {
                --this.modCount;
            }
            return bl2;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.removeFromList(this, 0, collection, false);
        try {
            ++this.modCount;
            boolean bl2 = this.list.removeAll(collection);
            if (!bl2) {
                --this.modCount;
            }
            return bl2;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.removeFromList(this, 0, collection, true);
        try {
            ++this.modCount;
            boolean bl2 = this.list.retainAll(collection);
            if (!bl2) {
                --this.modCount;
            }
            return bl2;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public void clear() {
        this.onProposedChange(Collections.emptyList(), 0, this.size());
        try {
            ++this.modCount;
            this.list.clear();
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public E get(int n2) {
        return this.list.get(n2);
    }

    @Override
    public E set(int n2, E e2) {
        this.onProposedChange(Collections.singletonList(e2), n2, n2 + 1);
        return this.list.set(n2, e2);
    }

    @Override
    public void add(int n2, E e2) {
        this.onProposedChange(Collections.singletonList(e2), n2, n2);
        try {
            ++this.modCount;
            this.list.add(n2, e2);
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public E remove(int n2) {
        this.onProposedChange(Collections.emptyList(), n2, n2 + 1);
        try {
            ++this.modCount;
            Object e2 = this.list.remove(n2);
            return e2;
        }
        catch (Exception exception) {
            --this.modCount;
            throw exception;
        }
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new VetoableListDecorator$VetoableListIteratorDecorator(this, (VetoableListDecorator$ModCountAccessor)new VetoableListDecorator$ModCountAccessorImpl(this), this.list.listIterator(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return new VetoableListDecorator$VetoableListIteratorDecorator(this, (VetoableListDecorator$ModCountAccessor)new VetoableListDecorator$ModCountAccessorImpl(this), this.list.listIterator(n2), n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return new VetoableListDecorator$VetoableSubListDecorator(this, new VetoableListDecorator$ModCountAccessorImpl(this), this.list.subList(n2, n3), n2);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

