/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.MapListenerHelper;
import com.sun.javafx.collections.ObservableMapWrapper$ObservableEntrySet;
import com.sun.javafx.collections.ObservableMapWrapper$ObservableKeySet;
import com.sun.javafx.collections.ObservableMapWrapper$ObservableValues;
import com.sun.javafx.collections.ObservableMapWrapper$SimpleChange;
import dev.protect.pv;
import dev.protect.tE;
import dev.protect.tF;
import dev.protect.tO;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObservableMapWrapper<K, V>
implements tO<K, V> {
    private ObservableMapWrapper$ObservableEntrySet entrySet;
    private ObservableMapWrapper$ObservableKeySet keySet;
    private ObservableMapWrapper$ObservableValues values;
    private MapListenerHelper<K, V> listenerHelper;
    private final Map<K, V> backingMap;

    public ObservableMapWrapper(Map<K, V> map) {
        this.backingMap = map;
    }

    protected void callObservers(tF<K, V> tF2) {
        MapListenerHelper.fireValueChangedEvent(this.listenerHelper, tF2);
    }

    @Override
    public void addListener(pv pv2) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, pv2);
    }

    @Override
    public void removeListener(pv pv2) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, pv2);
    }

    @Override
    public void addListener(tE<? super K, ? super V> tE2) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, tE2);
    }

    @Override
    public void removeListener(tE<? super K, ? super V> tE2) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, tE2);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.backingMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.backingMap.get(object);
    }

    @Override
    public V put(K k2, V v2) {
        V v3;
        if (this.backingMap.containsKey(k2)) {
            v3 = this.backingMap.put(k2, v2);
            if (v3 == null && v2 != null || v3 != null && !v3.equals(v2)) {
                this.callObservers(new ObservableMapWrapper$SimpleChange(this, k2, v3, v2, true, true));
            }
        } else {
            v3 = this.backingMap.put(k2, v2);
            this.callObservers(new ObservableMapWrapper$SimpleChange(this, k2, v3, v2, true, false));
        }
        return v3;
    }

    @Override
    public V remove(Object object) {
        if (!this.backingMap.containsKey(object)) {
            return null;
        }
        V v2 = this.backingMap.remove(object);
        this.callObservers(new ObservableMapWrapper$SimpleChange(this, object, v2, null, false, true));
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            iterator.remove();
            this.callObservers(new ObservableMapWrapper$SimpleChange(this, k2, v2, null, false, true));
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ObservableMapWrapper$ObservableKeySet(this);
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ObservableMapWrapper$ObservableValues(this);
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ObservableMapWrapper$ObservableEntrySet(this);
        }
        return this.entrySet;
    }

    public String toString() {
        return this.backingMap.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.backingMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }
}

