/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import dev.protect.tJ;
import dev.protect.tK;
import java.util.Arrays;

public final class ObservableFloatArrayImpl
extends tJ<tK>
implements tK {
    private static final float[] INITIAL = new float[0];
    private float[] array = INITIAL;
    private int size = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ObservableFloatArrayImpl() {
    }

    public ObservableFloatArrayImpl(float ... fArray) {
        this.setAll(fArray);
    }

    public ObservableFloatArrayImpl(tK tK2) {
        this.setAll(tK2);
    }

    public void clear() {
        this.resize(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void addAllInternal(tK tK2, int n2, int n3) {
        this.growCapacity(n3);
        tK2.copyTo(n2, this.array, this.size, n3);
        this.size += n3;
        this.fireChange(n3 != 0, this.size - n3, this.size);
    }

    private void addAllInternal(float[] fArray, int n2, int n3) {
        this.growCapacity(n3);
        System.arraycopy(fArray, n2, this.array, this.size, n3);
        this.size += n3;
        this.fireChange(n3 != 0, this.size - n3, this.size);
    }

    public void addAll(tK tK2) {
        this.addAllInternal(tK2, 0, tK2.size());
    }

    public void addAll(float ... fArray) {
        this.addAllInternal(fArray, 0, fArray.length);
    }

    public void addAll(tK tK2, int n2, int n3) {
        this.rangeCheck(tK2, n2, n3);
        this.addAllInternal(tK2, n2, n3);
    }

    public void addAll(float[] fArray, int n2, int n3) {
        this.rangeCheck(fArray, n2, n3);
        this.addAllInternal(fArray, n2, n3);
    }

    private void setAllInternal(tK tK2, int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = this.size() != n3;
        if (tK2 == this) {
            if (n2 == 0) {
                this.resize(n3);
            } else {
                System.arraycopy(this.array, n2, this.array, 0, n3);
                this.size = n3;
                this.fireChange(bl2, 0, this.size);
            }
        } else {
            this.size = 0;
            this.ensureCapacity(n3);
            tK2.copyTo(n2, this.array, 0, n3);
            this.size = n3;
            this.fireChange(bl2, 0, this.size);
        }
    }

    private void setAllInternal(float[] fArray, int n2, int n3) {
        boolean bl2 = this.size() != n3;
        this.size = 0;
        this.ensureCapacity(n3);
        System.arraycopy(fArray, n2, this.array, 0, n3);
        this.size = n3;
        this.fireChange(bl2, 0, this.size);
    }

    public void setAll(tK tK2) {
        this.setAllInternal(tK2, 0, tK2.size());
    }

    public void setAll(tK tK2, int n2, int n3) {
        this.rangeCheck(tK2, n2, n3);
        this.setAllInternal(tK2, n2, n3);
    }

    public void setAll(float[] fArray, int n2, int n3) {
        this.rangeCheck(fArray, n2, n3);
        this.setAllInternal(fArray, n2, n3);
    }

    @Override
    public void setAll(float[] fArray) {
        this.setAllInternal(fArray, 0, fArray.length);
    }

    @Override
    public void set(int n2, float[] fArray, int n3, int n4) {
        this.rangeCheck(n2 + n4);
        System.arraycopy(fArray, n3, this.array, n2, n4);
        this.fireChange(false, n2, n2 + n4);
    }

    public void set(int n2, tK tK2, int n3, int n4) {
        this.rangeCheck(n2 + n4);
        tK2.copyTo(n3, this.array, n2, n4);
        this.fireChange(false, n2, n2 + n4);
    }

    @Override
    public float[] toArray(float[] fArray) {
        if (fArray == null || this.size() > fArray.length) {
            fArray = new float[this.size()];
        }
        System.arraycopy(this.array, 0, fArray, 0, this.size());
        return fArray;
    }

    @Override
    public float get(int n2) {
        this.rangeCheck(n2 + 1);
        return this.array[n2];
    }

    public void set(int n2, float f2) {
        this.rangeCheck(n2 + 1);
        this.array[n2] = f2;
        this.fireChange(false, n2, n2 + 1);
    }

    public float[] toArray(int n2, float[] fArray, int n3) {
        this.rangeCheck(n2 + n3);
        if (fArray == null || n3 > fArray.length) {
            fArray = new float[n3];
        }
        System.arraycopy(this.array, n2, fArray, 0, n3);
        return fArray;
    }

    @Override
    public void copyTo(int n2, float[] fArray, int n3, int n4) {
        this.rangeCheck(n2 + n4);
        System.arraycopy(this.array, n2, fArray, n3, n4);
    }

    public void copyTo(int n2, tK tK2, int n3, int n4) {
        this.rangeCheck(n2 + n4);
        tK2.set(n3, this.array, n2, n4);
    }

    public void resize(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Can't resize to negative value: " + n2);
        }
        this.ensureCapacity(n2);
        int n3 = Math.min(this.size, n2);
        boolean bl2 = this.size != n2;
        this.size = n2;
        Arrays.fill(this.array, n3, this.size, 0.0f);
        this.fireChange(bl2, n3, n2);
    }

    private void growCapacity(int n2) {
        int n3 = this.size + n2;
        int n4 = this.array.length;
        if (n3 > this.array.length) {
            int n5 = n4 + (n4 >> 1);
            if (n5 < n3) {
                n5 = n3;
            }
            if (n5 > 0x7FFFFFF7) {
                n5 = ObservableFloatArrayImpl.hugeCapacity(n3);
            }
            this.ensureCapacity(n5);
        } else if (n2 > 0 && n3 < 0) {
            throw new OutOfMemoryError();
        }
    }

    public void ensureCapacity(int n2) {
        if (this.array.length < n2) {
            this.array = Arrays.copyOf(this.array, n2);
        }
    }

    private static int hugeCapacity(int n2) {
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        return n2 > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public void trimToSize() {
        if (this.array.length != this.size) {
            float[] fArray = new float[this.size];
            System.arraycopy(this.array, 0, fArray, 0, this.size);
            this.array = fArray;
        }
    }

    private void rangeCheck(int n2) {
        if (n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
    }

    private void rangeCheck(tK tK2, int n2, int n3) {
        if (tK2 == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > tK2.size()) {
            throw new ArrayIndexOutOfBoundsException(tK2.size());
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
    }

    private void rangeCheck(float[] fArray, int n2, int n3) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > fArray.length) {
            throw new ArrayIndexOutOfBoundsException(fArray.length);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
    }

    public String toString() {
        if (this.array == null) {
            return "null";
        }
        int n2 = this.size() - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(this.array[n3]);
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n3;
        }
    }
}

