/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ChangeHelper;
import dev.protect.tD;
import dev.protect.tM;

public abstract class NonIterableChange<E>
extends tD<E> {
    private final int from;
    private final int to;
    private boolean invalid = true;
    private static final int[] EMPTY_PERM = new int[0];

    protected NonIterableChange(int n2, int n3, tM<E> tM2) {
        super(tM2);
        this.from = n2;
        this.to = n3;
    }

    @Override
    public int getFrom() {
        this.checkState();
        return this.from;
    }

    @Override
    public int getTo() {
        this.checkState();
        return this.to;
    }

    @Override
    protected int[] getPermutation() {
        this.checkState();
        return EMPTY_PERM;
    }

    @Override
    public boolean next() {
        if (this.invalid) {
            this.invalid = false;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.invalid = true;
    }

    public void checkState() {
        if (this.invalid) {
            throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
        }
    }

    public String toString() {
        boolean bl2 = this.invalid;
        this.invalid = false;
        String string = this.wasPermutated() ? ChangeHelper.permChangeToString(this.getPermutation()) : (this.wasUpdated() ? ChangeHelper.updateChangeToString(this.from, this.to) : ChangeHelper.addRemoveChangeToString(this.from, this.to, this.getList(), this.getRemoved()));
        this.invalid = bl2;
        return "{ " + string + " }";
    }
}

