/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.win.WinAccessible;
import com.sun.glass.ui.win.WinVariant;
import dev.protect.XZ;
import dev.protect.Yd;
import dev.protect.xi;
import dev.protect.yb;
import dev.protect.yc;
import java.text.BreakIterator;

class WinTextRangeProvider {
    private static final int TextPatternRangeEndpoint_Start = 0;
    private static final int TextPatternRangeEndpoint_End = 1;
    private static final int TextUnit_Character = 0;
    private static final int TextUnit_Format = 1;
    private static final int TextUnit_Word = 2;
    private static final int TextUnit_Line = 3;
    private static final int TextUnit_Paragraph = 4;
    private static final int TextUnit_Page = 5;
    private static final int TextUnit_Document = 6;
    private static final int UIA_FontNameAttributeId = 40005;
    private static final int UIA_FontSizeAttributeId = 40006;
    private static final int UIA_FontWeightAttributeId = 40007;
    private static final int UIA_IsHiddenAttributeId = 40013;
    private static final int UIA_IsItalicAttributeId = 40014;
    private static final int UIA_IsReadOnlyAttributeId = 40015;
    private static int idCount;
    private int id;
    private int start;
    private int end;
    private WinAccessible accessible;
    private long peer;

    private static native void _initIDs();

    private native long _createTextRangeProvider(long var1);

    private native void _destroyTextRangeProvider(long var1);

    WinTextRangeProvider(WinAccessible winAccessible) {
        this.accessible = winAccessible;
        this.peer = this._createTextRangeProvider(winAccessible.getNativeAccessible());
        this.id = idCount++;
    }

    long getNativeProvider() {
        return this.peer;
    }

    void dispose() {
        this._destroyTextRangeProvider(this.peer);
        this.peer = 0L;
    }

    private void validateRange(String string) {
        if (string == null) {
            this.end = 0;
            this.start = 0;
            return;
        }
        int n2 = string.length();
        this.start = Math.max(0, Math.min(this.start, n2));
        this.end = Math.max(this.start, Math.min(this.end, n2));
    }

    void setRange(int n2, int n3) {
        this.start = n2;
        this.end = n3;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    public String toString() {
        return "Range(start: " + this.start + ", end: " + this.end + ", id: " + this.id + ")";
    }

    private Object getAttribute(yc yc2, Object ... objectArray) {
        return this.accessible.getAttribute(yc2, objectArray);
    }

    private boolean isWordStart(BreakIterator breakIterator, String string, int n2) {
        if (n2 == 0) {
            return true;
        }
        if (n2 >= string.length()) {
            return true;
        }
        if (n2 == -1) {
            return true;
        }
        return breakIterator.isBoundary(n2) && Character.isLetterOrDigit(string.charAt(n2));
    }

    private long Clone() {
        WinTextRangeProvider winTextRangeProvider = new WinTextRangeProvider(this.accessible);
        winTextRangeProvider.setRange(this.start, this.end);
        return winTextRangeProvider.getNativeProvider();
    }

    private boolean Compare(WinTextRangeProvider winTextRangeProvider) {
        if (winTextRangeProvider == null) {
            return false;
        }
        return this.accessible == winTextRangeProvider.accessible && this.start == winTextRangeProvider.start && this.end == winTextRangeProvider.end;
    }

    private int CompareEndpoints(int n2, WinTextRangeProvider winTextRangeProvider, int n3) {
        int n4 = n2 == 0 ? this.start : this.end;
        int n5 = n3 == 0 ? winTextRangeProvider.start : winTextRangeProvider.end;
        return n4 - n5;
    }

    private void ExpandToEnclosingUnit(int n2) {
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return;
        }
        this.validateRange(string);
        switch (n2) {
            case 0: {
                if (this.start == n3) {
                    --this.start;
                }
                this.end = this.start + 1;
                break;
            }
            case 1: 
            case 2: {
                int n4;
                BreakIterator breakIterator = BreakIterator.getWordInstance();
                breakIterator.setText(string);
                if (!this.isWordStart(breakIterator, string, this.start)) {
                    n4 = breakIterator.preceding(this.start);
                    while (!this.isWordStart(breakIterator, string, n4)) {
                        n4 = breakIterator.previous();
                    }
                    int n5 = this.start = n4 != -1 ? n4 : 0;
                }
                if (this.isWordStart(breakIterator, string, this.end)) break;
                n4 = breakIterator.following(this.end);
                while (!this.isWordStart(breakIterator, string, n4)) {
                    n4 = breakIterator.next();
                }
                this.end = n4 != -1 ? n4 : n3;
                break;
            }
            case 3: {
                Integer n6 = (Integer)this.getAttribute(yc.C, this.start);
                Integer n7 = (Integer)this.getAttribute(yc.D, n6);
                Integer n8 = (Integer)this.getAttribute(yc.B, n6);
                if (n6 == null || n8 == null || n7 == null) {
                    this.start = 0;
                    this.end = n3;
                    break;
                }
                this.start = n7;
                this.end = n8;
                break;
            }
            case 4: {
                int n9;
                Integer n10 = (Integer)this.getAttribute(yc.C, this.start);
                if (n10 == null) {
                    this.start = 0;
                    this.end = n3;
                    break;
                }
                BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                breakIterator.setText(string);
                if (!breakIterator.isBoundary(this.start)) {
                    n9 = breakIterator.preceding(this.start);
                    this.start = n9 != -1 ? n9 : 0;
                }
                this.end = (n9 = breakIterator.following(this.start)) != -1 ? n9 : n3;
                break;
            }
            case 5: 
            case 6: {
                this.start = 0;
                this.end = n3;
            }
        }
        this.validateRange(string);
    }

    private long FindAttribute(int n2, WinVariant winVariant, boolean bl2) {
        System.err.println("FindAttribute NOT IMPLEMENTED");
        return 0L;
    }

    private long FindText(String string, boolean bl2, boolean bl3) {
        if (string == null) {
            return 0L;
        }
        String string2 = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string2 == null) {
            return 0L;
        }
        String string3 = string2.substring(this.start, this.end);
        if (bl3) {
            string3 = string3.toLowerCase();
            string = string.toLowerCase();
        }
        int n2 = -1;
        n2 = bl2 ? string3.lastIndexOf(string) : string3.indexOf(string);
        if (n2 == -1) {
            return 0L;
        }
        WinTextRangeProvider winTextRangeProvider = new WinTextRangeProvider(this.accessible);
        winTextRangeProvider.setRange(this.start + n2, this.start + n2 + string.length());
        return winTextRangeProvider.getNativeProvider();
    }

    private WinVariant GetAttributeValue(int n2) {
        WinVariant winVariant = null;
        switch (n2) {
            case 40005: {
                XZ xZ2 = (XZ)this.getAttribute(yc.r, new Object[0]);
                if (xZ2 == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = xZ2.aD();
                break;
            }
            case 40006: {
                XZ xZ3 = (XZ)this.getAttribute(yc.r, new Object[0]);
                if (xZ3 == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)5;
                winVariant.dblVal = xZ3.gc();
                break;
            }
            case 40007: {
                XZ xZ4 = (XZ)this.getAttribute(yc.r, new Object[0]);
                if (xZ4 == null) break;
                boolean bl2 = xZ4.aF().toLowerCase().contains("bold");
                winVariant = new WinVariant();
                winVariant.vt = (short)3;
                winVariant.lVal = bl2 ? Yd.f.b() : Yd.c.b();
                break;
            }
            case 40013: 
            case 40015: {
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = false;
                break;
            }
            case 40014: {
                XZ xZ5 = (XZ)this.getAttribute(yc.r, new Object[0]);
                if (xZ5 == null) break;
                boolean bl3 = xZ5.aF().toLowerCase().contains("italic");
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = bl3;
                break;
            }
        }
        return winVariant;
    }

    private double[] GetBoundingRectangles() {
        xi[] xiArray;
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        this.validateRange(string);
        if (n2 == 0) {
            return new double[0];
        }
        int n3 = this.end;
        if (n3 > 0 && n3 > this.start && string.charAt(n3 - 1) == '\n') {
            --n3;
        }
        if (n3 > 0 && n3 > this.start && string.charAt(n3 - 1) == '\r') {
            --n3;
        }
        if (n3 > 0 && n3 > this.start && n3 == n2) {
            --n3;
        }
        if ((xiArray = (xi[])this.getAttribute(yc.b, this.start, n3)) != null) {
            double[] dArray = new double[xiArray.length * 4];
            int n4 = 0;
            for (int i2 = 0; i2 < xiArray.length; ++i2) {
                xi xi2 = xiArray[i2];
                float[] fArray = this.accessible.getPlatformBounds((float)xi2.am(), (float)xi2.an(), (float)xi2.ap(), (float)xi2.aq());
                dArray[n4++] = fArray[0];
                dArray[n4++] = fArray[1];
                dArray[n4++] = fArray[2];
                dArray[n4++] = fArray[3];
            }
            return dArray;
        }
        return null;
    }

    private long GetEnclosingElement() {
        return this.accessible.getNativeAccessible();
    }

    private String GetText(int n2) {
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return null;
        }
        this.validateRange(string);
        int n3 = n2 != -1 ? Math.min(this.end, this.start + n2) : this.end;
        return string.substring(this.start, n3);
    }

    private int Move(int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return 0;
        }
        int n5 = string.length();
        if (n5 == 0) {
            return 0;
        }
        switch (n2) {
            case 0: {
                int n6 = this.start;
                this.start = Math.max(0, Math.min(this.start + n3, n5 - 1));
                this.end = this.start + 1;
                n4 = this.start - n6;
                break;
            }
            case 1: 
            case 2: {
                BreakIterator breakIterator = BreakIterator.getWordInstance();
                breakIterator.setText(string);
                int n7 = this.start;
                while (!this.isWordStart(breakIterator, string, n7)) {
                    n7 = breakIterator.preceding(this.start);
                }
                while (n7 != -1 && n4 != n3) {
                    if (n3 > 0) {
                        n7 = breakIterator.following(n7);
                        while (!this.isWordStart(breakIterator, string, n7)) {
                            n7 = breakIterator.next();
                        }
                        ++n4;
                        continue;
                    }
                    n7 = breakIterator.preceding(n7);
                    while (!this.isWordStart(breakIterator, string, n7)) {
                        n7 = breakIterator.previous();
                    }
                    --n4;
                }
                if (n4 == 0) break;
                this.start = n7 != -1 ? n7 : (n3 > 0 ? n5 : 0);
                n7 = breakIterator.following(this.start);
                while (!this.isWordStart(breakIterator, string, n7)) {
                    n7 = breakIterator.next();
                }
                this.end = n7 != -1 ? n7 : n5;
                break;
            }
            case 3: {
                int n8;
                Integer n9 = (Integer)this.getAttribute(yc.C, this.start);
                if (n9 == null) {
                    return 0;
                }
                int n10 = n8 = n3 > 0 ? 1 : -1;
                for (n4 = 0; n3 != n4 && this.getAttribute(yc.D, n9 + n8) != null; n4 += n8) {
                    n9 = n9 + n8;
                }
                if (n4 == 0) break;
                Integer n11 = (Integer)this.getAttribute(yc.D, n9);
                Integer n12 = (Integer)this.getAttribute(yc.B, n9);
                if (n11 == null || n12 == null) {
                    return 0;
                }
                this.start = n11;
                this.end = n12;
                break;
            }
            case 4: {
                int n13;
                BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                breakIterator.setText(string);
                int n14 = n13 = breakIterator.isBoundary(this.start) ? this.start : breakIterator.preceding(this.start);
                while (n13 != -1 && n4 != n3) {
                    if (n3 > 0) {
                        n13 = breakIterator.following(n13);
                        ++n4;
                        continue;
                    }
                    n13 = breakIterator.preceding(n13);
                    --n4;
                }
                if (n4 == 0) break;
                this.start = n13 != -1 ? n13 : 0;
                n13 = breakIterator.following(this.start);
                this.end = n13 != -1 ? n13 : n5;
                break;
            }
            case 5: 
            case 6: {
                return 0;
            }
        }
        this.validateRange(string);
        return n4;
    }

    private int MoveEndpointByUnit(int n2, int n3, int n4) {
        if (n4 == 0) {
            return 0;
        }
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return 0;
        }
        int n5 = string.length();
        this.validateRange(string);
        int n6 = 0;
        int n7 = n2 == 0 ? this.start : this.end;
        switch (n3) {
            case 0: {
                int n8 = n7;
                n7 = Math.max(0, Math.min(n7 + n4, n5));
                n6 = n7 - n8;
                break;
            }
            case 1: 
            case 2: {
                BreakIterator breakIterator = BreakIterator.getWordInstance();
                breakIterator.setText(string);
                while (n7 != -1 && n6 != n4) {
                    if (n4 > 0) {
                        n7 = breakIterator.following(n7);
                        while (!this.isWordStart(breakIterator, string, n7)) {
                            n7 = breakIterator.next();
                        }
                        ++n6;
                        continue;
                    }
                    n7 = breakIterator.preceding(n7);
                    while (!this.isWordStart(breakIterator, string, n7)) {
                        n7 = breakIterator.previous();
                    }
                    --n6;
                }
                if (n7 != -1) break;
                n7 = n4 > 0 ? n5 : 0;
                break;
            }
            case 3: {
                Integer n9 = (Integer)this.getAttribute(yc.C, n7);
                Integer n10 = (Integer)this.getAttribute(yc.D, n9);
                Integer n11 = (Integer)this.getAttribute(yc.B, n9);
                if (n9 == null || n10 == null || n11 == null) {
                    n7 = n4 > 0 ? n5 : 0;
                    break;
                }
                int n12 = n4 > 0 ? 1 : -1;
                int n13 = n4 > 0 ? n11 : n10;
                if (n7 != n13) {
                    n6 += n12;
                }
                while (n4 != n6 && this.getAttribute(yc.D, n9 + n12) != null) {
                    n9 = n9 + n12;
                    n6 += n12;
                }
                if (n6 == 0) break;
                n10 = (Integer)this.getAttribute(yc.D, n9);
                n11 = (Integer)this.getAttribute(yc.B, n9);
                if (n10 == null || n11 == null) {
                    return 0;
                }
                n7 = n4 > 0 ? n11 : n10;
                break;
            }
            case 4: {
                BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                breakIterator.setText(string);
                while (n7 != -1 && n6 != n4) {
                    if (n4 > 0) {
                        n7 = breakIterator.following(n7);
                        ++n6;
                        continue;
                    }
                    n7 = breakIterator.preceding(n7);
                    --n6;
                }
                if (n7 != -1) break;
                n7 = n4 > 0 ? n5 : 0;
                break;
            }
            case 5: 
            case 6: {
                return 0;
            }
        }
        if (n2 == 0) {
            this.start = n7;
        } else {
            this.end = n7;
        }
        if (this.start > this.end) {
            this.start = this.end = n7;
        }
        this.validateRange(string);
        return n6;
    }

    private void MoveEndpointByRange(int n2, WinTextRangeProvider winTextRangeProvider, int n3) {
        int n4;
        String string = (String)this.getAttribute(yc.Z, new Object[0]);
        if (string == null) {
            return;
        }
        int n5 = string.length();
        int n6 = n4 = n3 == 0 ? winTextRangeProvider.start : winTextRangeProvider.end;
        if (n2 == 0) {
            this.start = n4;
        } else {
            this.end = n4;
        }
        if (this.start > this.end) {
            this.start = this.end = n4;
        }
        this.validateRange(string);
    }

    private void Select() {
        this.accessible.executeAction(yb.k, this.start, this.end);
    }

    private void AddToSelection() {
    }

    private void RemoveFromSelection() {
    }

    private void ScrollIntoView(boolean bl2) {
        this.accessible.executeAction(yb.i, this.start, this.end);
    }

    private long[] GetChildren() {
        return new long[0];
    }

    static {
        WinTextRangeProvider._initIDs();
        idCount = 1;
    }
}

