/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.win.WinTextRangeProvider;
import com.sun.glass.ui.win.WinVariant;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.WindowStage;
import dev.protect.Ah;
import dev.protect.RO;
import dev.protect.tM;
import dev.protect.to;
import dev.protect.xi;
import dev.protect.xo;
import dev.protect.yD;
import dev.protect.yb;
import dev.protect.yc;
import dev.protect.yd;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

final class WinAccessible
extends Accessible {
    private static int idCount;
    private static final int UIA_BoundingRectanglePropertyId = 30001;
    private static final int UIA_ProcessIdPropertyId = 30002;
    private static final int UIA_ControlTypePropertyId = 30003;
    private static final int UIA_LocalizedControlTypePropertyId = 30004;
    private static final int UIA_NamePropertyId = 30005;
    private static final int UIA_AcceleratorKeyPropertyId = 30006;
    private static final int UIA_AccessKeyPropertyId = 30007;
    private static final int UIA_HasKeyboardFocusPropertyId = 30008;
    private static final int UIA_IsKeyboardFocusablePropertyId = 30009;
    private static final int UIA_IsEnabledPropertyId = 30010;
    private static final int UIA_AutomationIdPropertyId = 30011;
    private static final int UIA_ClassNamePropertyId = 30012;
    private static final int UIA_HelpTextPropertyId = 30013;
    private static final int UIA_ClickablePointPropertyId = 30014;
    private static final int UIA_CulturePropertyId = 30015;
    private static final int UIA_IsControlElementPropertyId = 30016;
    private static final int UIA_IsContentElementPropertyId = 30017;
    private static final int UIA_LabeledByPropertyId = 30018;
    private static final int UIA_IsPasswordPropertyId = 30019;
    private static final int UIA_NativeWindowHandlePropertyId = 30020;
    private static final int UIA_ItemTypePropertyId = 30021;
    private static final int UIA_IsOffscreenPropertyId = 30022;
    private static final int UIA_OrientationPropertyId = 30023;
    private static final int UIA_FrameworkIdPropertyId = 30024;
    private static final int UIA_ValueValuePropertyId = 30045;
    private static final int UIA_RangeValueValuePropertyId = 30047;
    private static final int UIA_ExpandCollapseExpandCollapseStatePropertyId = 30070;
    private static final int UIA_ToggleToggleStatePropertyId = 30086;
    private static final int UIA_AriaRolePropertyId = 30101;
    private static final int UIA_ProviderDescriptionPropertyId = 30107;
    private static final int UIA_IsDialogPropertyId = 30174;
    private static final int UIA_InvokePatternId = 10000;
    private static final int UIA_SelectionPatternId = 10001;
    private static final int UIA_ValuePatternId = 10002;
    private static final int UIA_RangeValuePatternId = 10003;
    private static final int UIA_ScrollPatternId = 10004;
    private static final int UIA_ExpandCollapsePatternId = 10005;
    private static final int UIA_GridPatternId = 10006;
    private static final int UIA_GridItemPatternId = 10007;
    private static final int UIA_SelectionItemPatternId = 10010;
    private static final int UIA_TablePatternId = 10012;
    private static final int UIA_TableItemPatternId = 10013;
    private static final int UIA_TextPatternId = 10014;
    private static final int UIA_TogglePatternId = 10015;
    private static final int UIA_TransformPatternId = 10016;
    private static final int UIA_ScrollItemPatternId = 10017;
    private static final int UIA_ItemContainerPatternId = 10019;
    private static final int UIA_ButtonControlTypeId = 50000;
    private static final int UIA_CheckBoxControlTypeId = 50002;
    private static final int UIA_ComboBoxControlTypeId = 50003;
    private static final int UIA_EditControlTypeId = 50004;
    private static final int UIA_HyperlinkControlTypeId = 50005;
    private static final int UIA_ImageControlTypeId = 50006;
    private static final int UIA_ListItemControlTypeId = 50007;
    private static final int UIA_ListControlTypeId = 50008;
    private static final int UIA_MenuControlTypeId = 50009;
    private static final int UIA_MenuBarControlTypeId = 50010;
    private static final int UIA_MenuItemControlTypeId = 50011;
    private static final int UIA_ProgressBarControlTypeId = 50012;
    private static final int UIA_RadioButtonControlTypeId = 50013;
    private static final int UIA_ScrollBarControlTypeId = 50014;
    private static final int UIA_SliderControlTypeId = 50015;
    private static final int UIA_SpinnerControlTypeId = 50016;
    private static final int UIA_TabControlTypeId = 50018;
    private static final int UIA_TabItemControlTypeId = 50019;
    private static final int UIA_TextControlTypeId = 50020;
    private static final int UIA_ToolBarControlTypeId = 50021;
    private static final int UIA_TreeControlTypeId = 50023;
    private static final int UIA_TreeItemControlTypeId = 50024;
    private static final int UIA_GroupControlTypeId = 50026;
    private static final int UIA_ThumbControlTypeId = 50027;
    private static final int UIA_DataGridControlTypeId = 50028;
    private static final int UIA_DataItemControlTypeId = 50029;
    private static final int UIA_SplitButtonControlTypeId = 50031;
    private static final int UIA_WindowControlTypeId = 50032;
    private static final int UIA_PaneControlTypeId = 50033;
    private static final int UIA_TableControlTypeId = 50036;
    private static final int NavigateDirection_Parent = 0;
    private static final int NavigateDirection_NextSibling = 1;
    private static final int NavigateDirection_PreviousSibling = 2;
    private static final int NavigateDirection_FirstChild = 3;
    private static final int NavigateDirection_LastChild = 4;
    private static final int RowOrColumnMajor_RowMajor = 0;
    private static final int RowOrColumnMajor_ColumnMajor = 1;
    private static final int RowOrColumnMajor_Indeterminate = 2;
    private static final int UIA_MenuOpenedEventId = 20003;
    private static final int UIA_AutomationPropertyChangedEventId = 20004;
    private static final int UIA_AutomationFocusChangedEventId = 20005;
    private static final int UIA_MenuClosedEventId = 20007;
    private static final int UIA_SelectionItem_ElementRemovedFromSelectionEventId = 20011;
    private static final int UIA_SelectionItem_ElementSelectedEventId = 20012;
    private static final int UIA_Text_TextSelectionChangedEventId = 20014;
    private static final int UIA_Text_TextChangedEventId = 20015;
    private static final int UIA_MenuModeStartEventId = 20018;
    private static final int UIA_MenuModeEndEventId = 20019;
    private static final int SupportedTextSelection_None = 0;
    private static final int SupportedTextSelection_Single = 1;
    private static final int SupportedTextSelection_Multiple = 2;
    private static final int ExpandCollapseState_Collapsed = 0;
    private static final int ExpandCollapseState_Expanded = 1;
    private static final int ExpandCollapseState_PartiallyExpanded = 2;
    private static final int ExpandCollapseState_LeafNode = 3;
    private static final int ScrollAmount_LargeDecrement = 0;
    private static final int ScrollAmount_SmallDecrement = 1;
    private static final int ScrollAmount_NoAmount = 2;
    private static final int ScrollAmount_LargeIncrement = 3;
    private static final int ScrollAmount_SmallIncrement = 4;
    private static final int UIA_ScrollPatternNoScroll = -1;
    private static final int ToggleState_Off = 0;
    private static final int ToggleState_On = 1;
    private static final int ToggleState_Indeterminate = 2;
    private static final int UiaAppendRuntimeId = 3;
    private long peer = this._createGlassAccessible();
    private int id;
    private WinTextRangeProvider documentRange;
    private WinTextRangeProvider selectionRange;
    private int lastIndex = 0;

    private static native void _initIDs();

    private native long _createGlassAccessible();

    private native void _destroyGlassAccessible(long var1);

    private static native long UiaRaiseAutomationEvent(long var0, int var2);

    private static native long UiaRaiseAutomationPropertyChangedEvent(long var0, int var2, WinVariant var3, WinVariant var4);

    private static native boolean UiaClientsAreListening();

    WinAccessible() {
        if (this.peer == 0L) {
            throw new RuntimeException("could not create platform accessible");
        }
        this.id = idCount++;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selectionRange != null) {
            this.selectionRange.dispose();
            this.selectionRange = null;
        }
        if (this.documentRange != null) {
            this.documentRange.dispose();
            this.documentRange = null;
        }
        if (this.peer != 0L) {
            this._destroyGlassAccessible(this.peer);
            this.peer = 0L;
        }
    }

    @Override
    public void sendNotification(yc yc2) {
        if (this.isDisposed()) {
            return;
        }
        switch (yc2) {
            case p: {
                if (this.getView() != null) {
                    long l2 = this.GetFocus();
                    if (l2 == 0L) break;
                    WinAccessible.UiaRaiseAutomationEvent(l2, 20005);
                    break;
                }
                yD yD2 = (yD)this.getAttribute(yc.p, new Object[0]);
                if (yD2 != null) {
                    WinAccessible.UiaRaiseAutomationEvent(this.getNativeAccessible(yD2), 20005);
                    break;
                }
                Ah ah2 = (Ah)this.getAttribute(yc.T, new Object[0]);
                Accessible accessible = this.getAccessible(ah2);
                if (accessible == null) break;
                accessible.sendNotification(yc.p);
                break;
            }
            case o: {
                yD yD3 = (yD)this.getAttribute(yc.o, new Object[0]);
                long l3 = this.getNativeAccessible(yD3);
                if (l3 == 0L) break;
                WinAccessible.UiaRaiseAutomationEvent(l3, 20005);
                break;
            }
            case v: {
                if (this.getAttribute(yc.O, new Object[0]) != yd.a) break;
                this.notifyToggleState();
                break;
            }
            case U: {
                Object object = this.getAttribute(yc.O, new Object[0]);
                if (object == yd.a || object == yd.C) {
                    this.notifyToggleState();
                    break;
                }
                Boolean bl2 = (Boolean)this.getAttribute(yc.U, new Object[0]);
                if (bl2 == null) break;
                if (bl2.booleanValue()) {
                    WinAccessible.UiaRaiseAutomationEvent(this.peer, 20012);
                    break;
                }
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20011);
                break;
            }
            case q: {
                break;
            }
            case ad: {
                Double d2 = (Double)this.getAttribute(yc.ad, new Object[0]);
                if (d2 == null) break;
                WinVariant winVariant = new WinVariant();
                winVariant.vt = (short)5;
                winVariant.dblVal = 0.0;
                WinVariant winVariant2 = new WinVariant();
                winVariant2.vt = (short)5;
                winVariant2.dblVal = d2;
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30047, winVariant, winVariant2);
                break;
            }
            case X: 
            case W: {
                boolean bl3;
                if (this.selectionRange == null) break;
                Integer n2 = (Integer)this.getAttribute(yc.X, new Object[0]);
                boolean bl4 = n2 != null && n2.intValue() != this.selectionRange.getStart();
                Integer n3 = (Integer)this.getAttribute(yc.W, new Object[0]);
                boolean bl5 = bl3 = n3 != null && n3.intValue() != this.selectionRange.getEnd();
                if (!bl4 && !bl3) break;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20014);
                break;
            }
            case Z: {
                String string = (String)this.getAttribute(yc.Z, new Object[0]);
                if (string != null) {
                    WinVariant winVariant = new WinVariant();
                    winVariant.vt = (short)8;
                    winVariant.bstrVal = "";
                    WinVariant winVariant3 = new WinVariant();
                    winVariant3.vt = (short)8;
                    winVariant3.bstrVal = string;
                    if (this.getAttribute(yc.O, new Object[0]) == yd.y) {
                        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30005, winVariant, winVariant3);
                    } else {
                        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30045, winVariant, winVariant3);
                    }
                }
                if (this.selectionRange == null && this.documentRange == null) break;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20015);
                break;
            }
            case n: {
                Boolean bl6 = (Boolean)this.getAttribute(yc.n, new Object[0]);
                if (bl6 == null) break;
                WinVariant winVariant = new WinVariant();
                winVariant.vt = (short)3;
                winVariant.lVal = bl6 != false ? 0 : 1;
                WinVariant winVariant4 = new WinVariant();
                winVariant4.vt = (short)3;
                int n4 = winVariant4.lVal = bl6 != false ? 1 : 0;
                if (this.getAttribute(yc.O, new Object[0]) == yd.S) {
                    yD yD4;
                    Accessible accessible = this.getContainer();
                    Integer n5 = (Integer)this.getAttribute(yc.y, new Object[0]);
                    if (accessible == null || n5 == null || (yD4 = (yD)accessible.getAttribute(yc.f, n5, 0)) == null) break;
                    long l4 = ((WinAccessible)this.getAccessible(yD4)).getNativeAccessible();
                    WinAccessible.UiaRaiseAutomationPropertyChangedEvent(l4, 30070, winVariant, winVariant4);
                    break;
                }
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30070, winVariant, winVariant4);
                break;
            }
            case M: {
                break;
            }
            default: {
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20004);
            }
        }
    }

    private void notifyToggleState() {
        int n2 = this.get_ToggleState();
        WinVariant winVariant = new WinVariant();
        winVariant.vt = (short)3;
        winVariant.lVal = n2;
        WinVariant winVariant2 = new WinVariant();
        winVariant2.vt = (short)3;
        winVariant2.lVal = n2;
        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30086, winVariant, winVariant2);
    }

    @Override
    protected long getNativeAccessible() {
        return this.peer;
    }

    private Accessible getContainer() {
        if (this.isDisposed()) {
            return null;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case L: 
                case J: {
                    return this.getContainerAccessible(yd.M);
                }
                case k: {
                    return this.getContainerAccessible(yd.j);
                }
                case H: {
                    return this.getContainerAccessible(yd.I);
                }
                case q: {
                    return this.getContainerAccessible(yd.r);
                }
                case Q: {
                    return this.getContainerAccessible(yd.U);
                }
                case S: 
                case R: {
                    return this.getContainerAccessible(yd.T);
                }
            }
        }
        return null;
    }

    private int getControlType() {
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return 50026;
        }
        switch (yd2) {
            case d: {
                return 50009;
            }
            case w: 
            case b: 
            case l: 
            case o: {
                return 50011;
            }
            case PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_: 
            case n: 
            case C: 
            case h: 
            case f: {
                return 50000;
            }
            case G: {
                return 50031;
            }
            case r: 
            case I: {
                return 50018;
            }
            case H: 
            case q: {
                return 50019;
            }
            case x: {
                return 50015;
            }
            case s: {
                return this.getView() != null ? 50032 : 50033;
            }
            case z: {
                return 50020;
            }
            case B: 
            case t: 
            case A: {
                return 50004;
            }
            case T: 
            case M: {
                return 50036;
            }
            case j: {
                return 50008;
            }
            case k: {
                return 50007;
            }
            case J: 
            case R: {
                return 50029;
            }
            case i: {
                return 50006;
            }
            case v: {
                return 50013;
            }
            case a: {
                return 50002;
            }
            case c: {
                return 50003;
            }
            case g: {
                return 50005;
            }
            case U: {
                return 50023;
            }
            case Q: {
                return 50024;
            }
            case u: {
                return 50012;
            }
            case P: {
                return 50021;
            }
            case O: {
                return 50026;
            }
            case F: {
                return 50033;
            }
            case E: {
                return 50014;
            }
            case N: {
                return 50027;
            }
            case m: {
                return 50010;
            }
            case e: {
                return 50033;
            }
            case y: {
                return 50016;
            }
        }
        return 0;
    }

    private List<yD> getUnignoredChildren(WinAccessible winAccessible) {
        if (winAccessible == null) {
            return to.b();
        }
        tM tM2 = (tM)winAccessible.getAttribute(yc.d, new Object[0]);
        if (tM2 == null) {
            return to.b();
        }
        return tM2.stream().filter(yD::isVisible).collect(Collectors.toList());
    }

    private Accessible getRow() {
        Integer n2 = (Integer)this.getAttribute(yc.h, new Object[0]);
        if (n2 == null) {
            return null;
        }
        if (n2 != 0) {
            return null;
        }
        Integer n3 = (Integer)this.getAttribute(yc.S, new Object[0]);
        if (n3 == null) {
            return null;
        }
        Accessible accessible = this.getContainer();
        if (accessible == null) {
            return null;
        }
        yD yD2 = (yD)accessible.getAttribute(yc.Q, n3);
        return this.getAccessible(yD2);
    }

    private void changeSelection(boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return;
        }
        Accessible accessible = this.getContainer();
        if (accessible == null) {
            return;
        }
        yD yD2 = null;
        switch (yd2) {
            case k: {
                object2 = (Integer)this.getAttribute(yc.y, new Object[0]);
                if (object2 == null) break;
                yD2 = (yD)accessible.getAttribute(yc.w, object2);
                break;
            }
            case Q: {
                object2 = (Integer)this.getAttribute(yc.y, new Object[0]);
                if (object2 == null) break;
                yD2 = (yD)accessible.getAttribute(yc.Q, object2);
                break;
            }
            case J: 
            case R: {
                object2 = (Integer)this.getAttribute(yc.S, new Object[0]);
                object = (Integer)this.getAttribute(yc.h, new Object[0]);
                if (object2 == null || object == null) break;
                yD2 = (yD)accessible.getAttribute(yc.f, object2, object);
                break;
            }
        }
        if (yD2 != null) {
            object2 = to.a();
            if (!bl3 && (object = (tM)accessible.getAttribute(yc.V, new Object[0])) != null) {
                object2.addAll(object);
            }
            if (bl2) {
                object2.add(yD2);
            } else {
                object2.remove(yD2);
            }
            accessible.executeAction(yb.j, object2);
        }
    }

    private long GetPatternProvider(int n2) {
        if (this.isDisposed()) {
            return 0L;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return 0L;
        }
        boolean bl2 = false;
        switch (yd2) {
            case l: 
            case G: {
                bl2 = n2 == 10000 || n2 == 10005;
                break;
            }
            case w: 
            case b: {
                bl2 = n2 == 10000 || n2 == 10015;
                break;
            }
            case o: 
            case PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_: 
            case n: 
            case h: 
            case f: 
            case g: {
                bl2 = n2 == 10000;
                break;
            }
            case H: 
            case q: {
                bl2 = n2 == 10010;
                break;
            }
            case r: 
            case I: {
                bl2 = n2 == 10001;
                break;
            }
            case F: {
                bl2 = n2 == 10004;
                break;
            }
            case T: 
            case M: {
                bl2 = n2 == 10001 || n2 == 10006 || n2 == 10012 || n2 == 10004;
                break;
            }
            case R: {
                bl2 = n2 == 10010 || n2 == 10007 || n2 == 10013 || n2 == 10005 || n2 == 10017;
                break;
            }
            case J: {
                bl2 = n2 == 10010 || n2 == 10007 || n2 == 10013 || n2 == 10017;
                break;
            }
            case U: {
                bl2 = n2 == 10001 || n2 == 10004;
                break;
            }
            case Q: {
                bl2 = n2 == 10010 || n2 == 10005 || n2 == 10017;
                break;
            }
            case j: {
                bl2 = n2 == 10001 || n2 == 10004;
                break;
            }
            case k: {
                bl2 = n2 == 10010 || n2 == 10017;
                break;
            }
            case B: 
            case A: {
                bl2 = n2 == 10014 || n2 == 10002;
                break;
            }
            case z: {
                break;
            }
            case v: {
                bl2 = n2 == 10010;
                break;
            }
            case C: 
            case a: {
                bl2 = n2 == 10015;
                break;
            }
            case P: 
            case O: {
                bl2 = n2 == 10005;
                break;
            }
            case c: {
                bl2 = n2 == 10005 || n2 == 10002;
                break;
            }
            case x: 
            case u: 
            case E: {
                bl2 = n2 == 10003;
                break;
            }
        }
        return bl2 ? this.getNativeAccessible() : 0L;
    }

    private long get_HostRawElementProvider() {
        if (this.isDisposed()) {
            return 0L;
        }
        View view = this.getView();
        return view != null ? view.getNativeView() : 0L;
    }

    private WinVariant GetPropertyValue(int n2) {
        if (this.isDisposed()) {
            return null;
        }
        WinVariant winVariant = null;
        switch (n2) {
            case 30003: {
                int n3 = this.getControlType();
                if (n3 == 0) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)3;
                winVariant.lVal = n3;
                break;
            }
            case 30007: {
                String string = (String)this.getAttribute(yc.G, new Object[0]);
                if (string == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "Alt+" + string.toLowerCase();
                break;
            }
            case 30006: {
                RO rO2 = (RO)this.getAttribute(yc.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, new Object[0]);
                if (rO2 == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = rO2.toString().replaceAll("Shortcut", "Ctrl");
                break;
            }
            case 30005: {
                yD yD2;
                String string;
                yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
                if (yd2 == null) {
                    yd2 = yd.p;
                }
                switch (yd2) {
                    case B: 
                    case A: 
                    case c: {
                        string = null;
                        break;
                    }
                    case h: 
                    case f: {
                        string = (String)this.getAttribute(yc.Z, new Object[0]);
                        if (string != null && string.length() != 0) break;
                        if (yd2 == yd.h) {
                            string = "increment";
                            break;
                        }
                        string = "decrement";
                        break;
                    }
                    default: {
                        string = (String)this.getAttribute(yc.Z, new Object[0]);
                    }
                }
                if ((string == null || string.length() == 0) && (yD2 = (yD)this.getAttribute(yc.z, new Object[0])) != null) {
                    string = (String)this.getAccessible(yD2).getAttribute(yc.Z, new Object[0]);
                }
                if (string == null || string.length() == 0) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = string;
                break;
            }
            case 30013: {
                String string = (String)this.getAttribute(yc.t, new Object[0]);
                if (string == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = string;
                break;
            }
            case 30004: {
                String string = (String)this.getAttribute(yc.P, new Object[0]);
                if (string == null) {
                    yd yd3 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
                    if (yd3 == null) {
                        yd3 = yd.p;
                    }
                    switch (yd3) {
                        case O: {
                            string = "title pane";
                            break;
                        }
                        case q: {
                            string = "page";
                            break;
                        }
                        case V: {
                            string = "dialog";
                            break;
                        }
                    }
                }
                if (string == null) break;
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = string;
                break;
            }
            case 30008: {
                yD yD3;
                yD yD4;
                Accessible accessible;
                Ah ah2;
                Boolean bl2 = (Boolean)this.getAttribute(yc.q, new Object[0]);
                if (Boolean.FALSE.equals(bl2) && (ah2 = (Ah)this.getAttribute(yc.T, new Object[0])) != null && (accessible = this.getAccessible(ah2)) != null && (yD4 = (yD)accessible.getAttribute(yc.p, new Object[0])) != null && this.getNativeAccessible(yD3 = (yD)this.getAccessible(yD4).getAttribute(yc.o, new Object[0])) == this.peer) {
                    bl2 = true;
                }
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = bl2 != null ? bl2 : false;
                break;
            }
            case 30174: {
                yd yd4 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = yd4 == yd.V;
                break;
            }
            case 30016: 
            case 30017: {
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = this.getView() != null || !this.isIgnored();
                break;
            }
            case 30010: {
                Boolean bl3 = (Boolean)this.getAttribute(yc.j, new Object[0]);
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = bl3 != null ? !bl3.booleanValue() : true;
                break;
            }
            case 30009: {
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = true;
                break;
            }
            case 30019: {
                yd yd5 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
                winVariant = new WinVariant();
                winVariant.vt = (short)11;
                winVariant.boolVal = yd5 == yd.t;
                break;
            }
            case 30011: {
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "JavaFX" + this.id;
                break;
            }
            case 30107: {
                winVariant = new WinVariant();
                winVariant.vt = (short)8;
                winVariant.bstrVal = "JavaFXProvider";
                break;
            }
        }
        return winVariant;
    }

    private Screen getScreen() {
        Ah ah2 = (Ah)this.getAttribute(yc.T, new Object[0]);
        if (ah2 == null || ah2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_() == null) {
            return null;
        }
        TKStage tKStage = WindowHelper.getPeer(ah2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_());
        if (!(tKStage instanceof WindowStage)) {
            return null;
        }
        WindowStage windowStage = (WindowStage)tKStage;
        if (windowStage.getPlatformWindow() == null) {
            return null;
        }
        return windowStage.getPlatformWindow().getScreen();
    }

    float[] getPlatformBounds(float f2, float f3, float f4, float f5) {
        float[] fArray = new float[]{f2, f3, f4, f5};
        Screen screen = this.getScreen();
        if (screen == null) {
            return fArray;
        }
        fArray[0] = screen.toPlatformX(f2);
        fArray[1] = screen.toPlatformY(f3);
        fArray[2] = (float)Math.ceil(f4 * screen.getPlatformScaleX());
        fArray[3] = (float)Math.ceil(f5 * screen.getPlatformScaleY());
        return fArray;
    }

    private float[] get_BoundingRectangle() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        xi xi2 = (xi)this.getAttribute(yc.a, new Object[0]);
        if (xi2 != null) {
            return this.getPlatformBounds((float)xi2.am(), (float)xi2.an(), (float)xi2.ap(), (float)xi2.aq());
        }
        return null;
    }

    private long get_FragmentRoot() {
        if (this.isDisposed()) {
            return 0L;
        }
        Ah ah2 = (Ah)this.getAttribute(yc.T, new Object[0]);
        if (ah2 == null) {
            return 0L;
        }
        WinAccessible winAccessible = (WinAccessible)this.getAccessible(ah2);
        if (winAccessible == null || winAccessible.isDisposed()) {
            return 0L;
        }
        return winAccessible.getNativeAccessible();
    }

    private long[] GetEmbeddedFragmentRoots() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private int[] GetRuntimeId() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        return new int[]{3, this.id};
    }

    private long NavigateListView(WinAccessible winAccessible, int n2) {
        Object object;
        Accessible accessible = winAccessible.getContainer();
        if (accessible == null) {
            return 0L;
        }
        Integer n3 = (Integer)accessible.getAttribute(yc.x, new Object[0]);
        if (n3 == null || n3 == 0) {
            return 0L;
        }
        Integer n4 = (Integer)winAccessible.getAttribute(yc.y, new Object[0]);
        if (n4 == null) {
            return 0L;
        }
        if (0 > n4 || n4 >= n3) {
            return 0L;
        }
        switch (n2) {
            case 1: {
                object = n4;
                n4 = n4 + 1;
                break;
            }
            case 2: {
                object = n4;
                n4 = n4 - 1;
                break;
            }
            case 3: {
                n4 = 0;
                break;
            }
            case 4: {
                n4 = n3 - 1;
            }
        }
        if (0 > n4 || n4 >= n3) {
            return 0L;
        }
        object = (yD)accessible.getAttribute(yc.w, n4);
        return this.getNativeAccessible((yD)object);
    }

    private long Navigate(int n3) {
        if (this.isDisposed()) {
            return 0L;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        boolean bl2 = yd2 == yd.Q;
        yD yD2 = null;
        switch (n3) {
            case 0: {
                if (this.getView() != null) {
                    return 0L;
                }
                if (bl2) {
                    yD2 = (yD)this.getAttribute(yc.ac, new Object[0]);
                    if (yD2 != null) break;
                    WinAccessible winAccessible = (WinAccessible)this.getContainer();
                    return winAccessible != null ? winAccessible.getNativeAccessible() : 0L;
                }
                yD2 = (yD)this.getAttribute(yc.M, new Object[0]);
                if (yD2 != null) break;
                Ah ah2 = (Ah)this.getAttribute(yc.T, new Object[0]);
                WinAccessible winAccessible = (WinAccessible)this.getAccessible(ah2);
                if (winAccessible == null || winAccessible == this || winAccessible.isDisposed()) {
                    return 0L;
                }
                return winAccessible.getNativeAccessible();
            }
            case 1: 
            case 2: {
                Function<Integer, yD> function;
                List<yD> list;
                if (yd2 == yd.k) {
                    return this.NavigateListView(this, n3);
                }
                yD yD3 = (yD)this.getAttribute(bl2 ? yc.ac : yc.M, new Object[0]);
                if (yD3 == null) break;
                WinAccessible winAccessible = (WinAccessible)this.getAccessible(yD3);
                int n4 = 0;
                if (bl2) {
                    list = (Integer)winAccessible.getAttribute(yc.ab, new Object[0]);
                    if (list == null) {
                        return 0L;
                    }
                    n4 = (Integer)((Object)list);
                    function = n2 -> (yD)winAccessible.getAttribute(yc.aa, n2);
                } else {
                    list = this.getUnignoredChildren(winAccessible);
                    if (list == null) {
                        return 0L;
                    }
                    n4 = list.size();
                    function = n2 -> (yD)list.get((int)n2);
                }
                int n5 = winAccessible.lastIndex;
                int n6 = -1;
                if (0 <= n5 && n5 < n4 && this.getNativeAccessible(function.apply(n5)) == this.peer) {
                    n6 = n5;
                } else {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        if (this.getNativeAccessible(function.apply(i2)) != this.peer) continue;
                        n6 = i2;
                        break;
                    }
                }
                if (n6 == -1) break;
                n6 = n3 == 1 ? ++n6 : --n6;
                if (0 > n6 || n6 >= n4) break;
                yD2 = function.apply(n6);
                winAccessible.lastIndex = n6;
                break;
            }
            case 3: 
            case 4: {
                this.lastIndex = -1;
                if (yd2 == yd.j) {
                    this.getAttribute(yc.w, 0);
                }
                if (yd2 == yd.U) {
                    this.lastIndex = 0;
                    yD2 = (yD)this.getAttribute(yc.Q, 0);
                    break;
                }
                if (bl2) {
                    Integer n7 = (Integer)this.getAttribute(yc.ab, new Object[0]);
                    if (n7 == null || n7 <= 0) break;
                    this.lastIndex = n3 == 3 ? 0 : n7 - 1;
                    yD2 = (yD)this.getAttribute(yc.aa, this.lastIndex);
                    break;
                }
                List<yD> list = this.getUnignoredChildren(this);
                if (list != null && list.size() > 0) {
                    this.lastIndex = n3 == 3 ? 0 : list.size() - 1;
                    yD2 = list.get(this.lastIndex);
                }
                if (yD2 == null || (yd2 = (yd)((Object)this.getAccessible(yD2).getAttribute(yc.O, new Object[0]))) != yd.k) break;
                WinAccessible winAccessible = (WinAccessible)this.getAccessible(yD2);
                return this.NavigateListView(winAccessible, n3);
            }
        }
        return this.getNativeAccessible(yD2);
    }

    private void SetFocus() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(yb.g, new Object[0]);
    }

    private long ElementProviderFromPoint(double d2, double d3) {
        if (this.isDisposed()) {
            return 0L;
        }
        yD yD2 = (yD)this.getAttribute(yc.I, new xo(d2, d3));
        return this.getNativeAccessible(yD2);
    }

    private long GetFocus() {
        if (this.isDisposed()) {
            return 0L;
        }
        yD yD2 = (yD)this.getAttribute(yc.p, new Object[0]);
        if (yD2 == null) {
            return 0L;
        }
        yD yD3 = (yD)this.getAccessible(yD2).getAttribute(yc.o, new Object[0]);
        if (yD3 != null) {
            return this.getNativeAccessible(yD3);
        }
        return this.getNativeAccessible(yD2);
    }

    private void AdviseEventAdded(int n2, long l2) {
    }

    private void AdviseEventRemoved(int n2, long l2) {
    }

    private void Invoke() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(yb.e, new Object[0]);
    }

    private long[] GetSelection() {
        if (this.isDisposed()) {
            return null;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return null;
        }
        switch (yd2) {
            case T: 
            case M: 
            case j: 
            case U: {
                tM tM2 = (tM)this.getAttribute(yc.V, new Object[0]);
                if (tM2 == null) break;
                return tM2.stream().mapToLong(yD2 -> this.getNativeAccessible((yD)yD2)).toArray();
            }
            case r: 
            case I: {
                yD yD3 = (yD)this.getAttribute(yc.o, new Object[0]);
                if (yD3 == null) break;
                return new long[]{this.getNativeAccessible(yD3)};
            }
            case B: 
            case A: {
                Integer n2;
                if (this.selectionRange == null) {
                    this.selectionRange = new WinTextRangeProvider(this);
                }
                int n3 = (n2 = (Integer)this.getAttribute(yc.X, new Object[0])) != null ? n2 : 0;
                int n4 = -1;
                int n5 = -1;
                if (n3 >= 0) {
                    n2 = (Integer)this.getAttribute(yc.W, new Object[0]);
                    int n6 = n4 = n2 != null ? n2 : 0;
                    if (n4 >= n3) {
                        String string = (String)this.getAttribute(yc.Z, new Object[0]);
                        int n7 = n5 = string != null ? string.length() : 0;
                    }
                }
                if (n5 != -1 && n4 <= n5) {
                    this.selectionRange.setRange(n3, n4);
                } else {
                    this.selectionRange.setRange(0, 0);
                }
                return new long[]{this.selectionRange.getNativeProvider()};
            }
        }
        return null;
    }

    private boolean get_CanSelectMultiple() {
        if (this.isDisposed()) {
            return false;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case T: 
                case M: 
                case j: 
                case U: {
                    return Boolean.TRUE.equals(this.getAttribute(yc.H, new Object[0]));
                }
            }
        }
        return false;
    }

    private boolean get_IsSelectionRequired() {
        return !this.isDisposed();
    }

    private void SetValue(double d2) {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case x: 
                case E: {
                    this.executeAction(yb.m, d2);
                    break;
                }
            }
        }
    }

    private double get_Value() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (Boolean.TRUE.equals(this.getAttribute(yc.v, new Object[0]))) {
            return 0.0;
        }
        Double d2 = (Double)this.getAttribute(yc.ad, new Object[0]);
        return d2 != null ? d2 : 0.0;
    }

    private boolean get_IsReadOnly() {
        if (this.isDisposed()) {
            return false;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case x: {
                    return false;
                }
                case E: {
                    return true;
                }
                case B: 
                case A: 
                case c: {
                    return Boolean.FALSE.equals(this.getAttribute(yc.m, new Object[0]));
                }
            }
        }
        return true;
    }

    private double get_Maximum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double d2 = (Double)this.getAttribute(yc.F, new Object[0]);
        return d2 != null ? d2 : 0.0;
    }

    private double get_Minimum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double d2 = (Double)this.getAttribute(yc.E, new Object[0]);
        return d2 != null ? d2 : 0.0;
    }

    private double get_LargeChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 10.0;
    }

    private double get_SmallChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 3.0;
    }

    private void SetValueString(String string) {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case B: 
                case A: {
                    this.executeAction(yb.l, string);
                    break;
                }
            }
        }
    }

    private String get_ValueString() {
        if (this.isDisposed()) {
            return null;
        }
        return (String)this.getAttribute(yc.Z, new Object[0]);
    }

    private void Select() {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case H: 
                case q: {
                    this.executeAction(yb.g, new Object[0]);
                    break;
                }
                case PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_: 
                case C: 
                case h: 
                case f: 
                case v: {
                    this.executeAction(yb.e, new Object[0]);
                    break;
                }
                case J: 
                case k: 
                case Q: 
                case R: {
                    this.changeSelection(true, true);
                    break;
                }
            }
        }
    }

    private void AddToSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.changeSelection(true, false);
    }

    private void RemoveFromSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.changeSelection(false, false);
    }

    private boolean get_IsSelected() {
        if (this.isDisposed()) {
            return false;
        }
        return Boolean.TRUE.equals(this.getAttribute(yc.U, new Object[0]));
    }

    private long get_SelectionContainer() {
        if (this.isDisposed()) {
            return 0L;
        }
        WinAccessible winAccessible = (WinAccessible)this.getContainer();
        return winAccessible != null ? winAccessible.getNativeAccessible() : 0L;
    }

    private long[] GetVisibleRanges() {
        if (this.isDisposed()) {
            return null;
        }
        return new long[]{this.get_DocumentRange()};
    }

    private long RangeFromChild(long l2) {
        if (this.isDisposed()) {
            return 0L;
        }
        return 0L;
    }

    private long RangeFromPoint(double d2, double d3) {
        if (this.isDisposed()) {
            return 0L;
        }
        Integer n2 = (Integer)this.getAttribute(yc.J, new xo(d2, d3));
        if (n2 != null) {
            WinTextRangeProvider winTextRangeProvider = new WinTextRangeProvider(this);
            winTextRangeProvider.setRange(n2, n2);
            return winTextRangeProvider.getNativeProvider();
        }
        return 0L;
    }

    private long get_DocumentRange() {
        String string;
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.documentRange == null) {
            this.documentRange = new WinTextRangeProvider(this);
        }
        if ((string = (String)this.getAttribute(yc.Z, new Object[0])) == null) {
            return 0L;
        }
        this.documentRange.setRange(0, string.length());
        return this.documentRange.getNativeProvider();
    }

    private int get_SupportedTextSelection() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private int get_ColumnCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n2 = (Integer)this.getAttribute(yc.g, new Object[0]);
        return n2 != null ? n2 : 1;
    }

    private int get_RowCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n2 = (Integer)this.getAttribute(yc.R, new Object[0]);
        return n2 != null ? n2 : 0;
    }

    private long GetItem(int n2, int n3) {
        if (this.isDisposed()) {
            return 0L;
        }
        yD yD2 = (yD)this.getAttribute(yc.f, n2, n3);
        return this.getNativeAccessible(yD2);
    }

    private int get_Column() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n2 = (Integer)this.getAttribute(yc.h, new Object[0]);
        return n2 != null ? n2 : 0;
    }

    private int get_ColumnSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private long get_ContainingGrid() {
        if (this.isDisposed()) {
            return 0L;
        }
        WinAccessible winAccessible = (WinAccessible)this.getContainer();
        return winAccessible != null ? winAccessible.getNativeAccessible() : 0L;
    }

    private int get_Row() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer n2 = null;
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 != null) {
            switch (yd2) {
                case L: 
                case k: 
                case S: {
                    n2 = (Integer)this.getAttribute(yc.y, new Object[0]);
                    break;
                }
                case J: 
                case R: {
                    n2 = (Integer)this.getAttribute(yc.S, new Object[0]);
                    break;
                }
            }
        }
        return n2 != null ? n2 : 0;
    }

    private int get_RowSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private long[] GetColumnHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private long[] GetRowHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private int get_RowOrColumnMajor() {
        if (this.isDisposed()) {
            return 0;
        }
        return 0;
    }

    private long[] GetColumnHeaderItems() {
        if (this.isDisposed()) {
            return null;
        }
        Integer n2 = (Integer)this.getAttribute(yc.h, new Object[0]);
        if (n2 == null) {
            return null;
        }
        Accessible accessible = this.getContainer();
        if (accessible == null) {
            return null;
        }
        yD yD2 = (yD)accessible.getAttribute(yc.e, n2);
        if (yD2 == null) {
            return null;
        }
        return new long[]{this.getNativeAccessible(yD2)};
    }

    private long[] GetRowHeaderItems() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private void Toggle() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(yb.e, new Object[0]);
    }

    private int get_ToggleState() {
        if (this.isDisposed()) {
            return 0;
        }
        if (Boolean.TRUE.equals(this.getAttribute(yc.v, new Object[0]))) {
            return 2;
        }
        boolean bl2 = Boolean.TRUE.equals(this.getAttribute(yc.U, new Object[0]));
        return bl2 ? 1 : 0;
    }

    private void Collapse() {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == yd.P) {
            yD yD2 = (yD)this.getAttribute(yc.L, new Object[0]);
            if (yD2 != null) {
                this.getAccessible(yD2).executeAction(yb.e, new Object[0]);
            }
            return;
        }
        if (yd2 == yd.R) {
            Accessible accessible = this.getRow();
            if (accessible != null) {
                accessible.executeAction(yb.b, new Object[0]);
            }
            return;
        }
        this.executeAction(yb.b, new Object[0]);
    }

    private void Expand() {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == yd.P) {
            yD yD2 = (yD)this.getAttribute(yc.L, new Object[0]);
            if (yD2 != null) {
                this.getAccessible(yD2).executeAction(yb.e, new Object[0]);
            }
            return;
        }
        if (yd2 == yd.R) {
            Accessible accessible = this.getRow();
            if (accessible != null) {
                accessible.executeAction(yb.d, new Object[0]);
            }
            return;
        }
        this.executeAction(yb.d, new Object[0]);
    }

    private int get_ExpandCollapseState() {
        Object object;
        if (this.isDisposed()) {
            return 0;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == yd.P && (object = (yD)this.getAttribute(yc.L, new Object[0])) != null) {
            boolean bl2 = Boolean.TRUE.equals(this.getAccessible((yD)object).getAttribute(yc.af, new Object[0]));
            return bl2 ? 0 : 1;
        }
        if (yd2 == yd.R) {
            object = this.getRow();
            if (object == null) {
                return 3;
            }
            Object object2 = ((Accessible)object).getAttribute(yc.A, new Object[0]);
            if (Boolean.TRUE.equals(object2)) {
                return 3;
            }
            object2 = ((Accessible)object).getAttribute(yc.n, new Object[0]);
            boolean bl3 = Boolean.TRUE.equals(object2);
            return bl3 ? 1 : 0;
        }
        object = this.getAttribute(yc.A, new Object[0]);
        if (Boolean.TRUE.equals(object)) {
            return 3;
        }
        object = this.getAttribute(yc.n, new Object[0]);
        boolean bl4 = Boolean.TRUE.equals(object);
        return bl4 ? 1 : 0;
    }

    private boolean get_CanMove() {
        return false;
    }

    private boolean get_CanResize() {
        return false;
    }

    private boolean get_CanRotate() {
        return false;
    }

    private void Move(double d2, double d3) {
    }

    private void Resize(double d2, double d3) {
    }

    private void Rotate(double d2) {
    }

    private void Scroll(int n2, int n3) {
        Accessible accessible;
        yD yD2;
        if (this.isDisposed()) {
            return;
        }
        if (this.get_VerticallyScrollable()) {
            yD2 = (yD)this.getAttribute(yc.ae, new Object[0]);
            accessible = this.getAccessible(yD2);
            if (accessible == null) {
                return;
            }
            switch (n3) {
                case 3: {
                    accessible.executeAction(yb.a, new Object[0]);
                    break;
                }
                case 4: {
                    accessible.executeAction(yb.f, new Object[0]);
                    break;
                }
                case 0: {
                    accessible.executeAction(yb.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, new Object[0]);
                    break;
                }
                case 1: {
                    accessible.executeAction(yb.c, new Object[0]);
                    break;
                }
            }
        }
        if (this.get_HorizontallyScrollable()) {
            yD2 = (yD)this.getAttribute(yc.u, new Object[0]);
            accessible = this.getAccessible(yD2);
            if (accessible == null) {
                return;
            }
            switch (n2) {
                case 3: {
                    accessible.executeAction(yb.a, new Object[0]);
                    break;
                }
                case 4: {
                    accessible.executeAction(yb.f, new Object[0]);
                    break;
                }
                case 0: {
                    accessible.executeAction(yb.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, new Object[0]);
                    break;
                }
                case 1: {
                    accessible.executeAction(yb.c, new Object[0]);
                    break;
                }
            }
        }
    }

    private void SetScrollPercent(double d2, double d3) {
        Double d4;
        Double d5;
        Accessible accessible;
        yD yD2;
        if (this.isDisposed()) {
            return;
        }
        if (d3 != -1.0 && this.get_VerticallyScrollable()) {
            yD2 = (yD)this.getAttribute(yc.ae, new Object[0]);
            accessible = this.getAccessible(yD2);
            if (accessible == null) {
                return;
            }
            d5 = (Double)accessible.getAttribute(yc.E, new Object[0]);
            d4 = (Double)accessible.getAttribute(yc.F, new Object[0]);
            if (d5 != null && d4 != null) {
                accessible.executeAction(yb.m, (d4 - d5) * (d3 / 100.0) + d5);
            }
        }
        if (d2 != -1.0 && this.get_HorizontallyScrollable()) {
            yD2 = (yD)this.getAttribute(yc.u, new Object[0]);
            accessible = this.getAccessible(yD2);
            if (accessible == null) {
                return;
            }
            d5 = (Double)accessible.getAttribute(yc.E, new Object[0]);
            d4 = (Double)accessible.getAttribute(yc.F, new Object[0]);
            if (d5 != null && d4 != null) {
                accessible.executeAction(yb.m, (d4 - d5) * (d2 / 100.0) + d5);
            }
        }
    }

    private boolean get_HorizontallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        yD yD2 = (yD)this.getAttribute(yc.u, new Object[0]);
        if (yD2 == null) {
            return false;
        }
        Boolean bl2 = (Boolean)this.getAccessible(yD2).getAttribute(yc.af, new Object[0]);
        return Boolean.TRUE.equals(bl2);
    }

    private double get_HorizontalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return -1.0;
        }
        yD yD2 = (yD)this.getAttribute(yc.u, new Object[0]);
        if (yD2 != null) {
            Accessible accessible = this.getAccessible(yD2);
            Double d2 = (Double)accessible.getAttribute(yc.ad, new Object[0]);
            if (d2 == null) {
                return 0.0;
            }
            Double d3 = (Double)accessible.getAttribute(yc.F, new Object[0]);
            if (d3 == null) {
                return 0.0;
            }
            Double d4 = (Double)accessible.getAttribute(yc.E, new Object[0]);
            if (d4 == null) {
                return 0.0;
            }
            return 100.0 * (d2 - d4) / (d3 - d4);
        }
        return 0.0;
    }

    private double get_HorizontalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return 100.0;
        }
        yD yD2 = (yD)this.getAttribute(yc.i, new Object[0]);
        if (yD2 == null) {
            return 100.0;
        }
        xi xi2 = (xi)this.getAccessible(yD2).getAttribute(yc.a, new Object[0]);
        if (xi2 == null) {
            return 0.0;
        }
        xi xi3 = (xi)this.getAttribute(yc.a, new Object[0]);
        if (xi3 == null) {
            return 0.0;
        }
        return xi3.ap() / xi2.ap() * 100.0;
    }

    private boolean get_VerticallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        yD yD2 = (yD)this.getAttribute(yc.ae, new Object[0]);
        if (yD2 == null) {
            return false;
        }
        Boolean bl2 = (Boolean)this.getAccessible(yD2).getAttribute(yc.af, new Object[0]);
        return Boolean.TRUE.equals(bl2);
    }

    private double get_VerticalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return -1.0;
        }
        yD yD2 = (yD)this.getAttribute(yc.ae, new Object[0]);
        if (yD2 != null) {
            Accessible accessible = this.getAccessible(yD2);
            Double d2 = (Double)accessible.getAttribute(yc.ad, new Object[0]);
            if (d2 == null) {
                return 0.0;
            }
            Double d3 = (Double)accessible.getAttribute(yc.F, new Object[0]);
            if (d3 == null) {
                return 0.0;
            }
            Double d4 = (Double)accessible.getAttribute(yc.E, new Object[0]);
            if (d4 == null) {
                return 0.0;
            }
            return 100.0 * (d2 - d4) / (d3 - d4);
        }
        return 0.0;
    }

    private double get_VerticalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return 100.0;
        }
        double d2 = 0.0;
        xi xi2 = (xi)this.getAttribute(yc.a, new Object[0]);
        if (xi2 == null) {
            return 0.0;
        }
        double d3 = xi2.aq();
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return 0.0;
        }
        if (yd2 == yd.F) {
            yD yD2 = (yD)this.getAttribute(yc.i, new Object[0]);
            if (yD2 != null) {
                xi xi3 = (xi)this.getAccessible(yD2).getAttribute(yc.a, new Object[0]);
                d2 = xi3 == null ? 0.0 : xi3.aq();
            }
        } else {
            Integer n2 = 0;
            switch (yd2) {
                case j: {
                    n2 = (Integer)this.getAttribute(yc.x, new Object[0]);
                    break;
                }
                case T: 
                case M: 
                case U: {
                    n2 = (Integer)this.getAttribute(yc.R, new Object[0]);
                    break;
                }
            }
            d2 = n2 == null ? 0.0 : (double)(n2 * 24);
        }
        return d2 == 0.0 ? 0.0 : d3 / d2 * 100.0;
    }

    private void ScrollIntoView() {
        if (this.isDisposed()) {
            return;
        }
        yd yd2 = (yd)((Object)this.getAttribute(yc.O, new Object[0]));
        if (yd2 == null) {
            return;
        }
        Accessible accessible = this.getContainer();
        if (accessible == null) {
            return;
        }
        yD yD2 = null;
        switch (yd2) {
            case k: {
                Integer n2 = (Integer)this.getAttribute(yc.y, new Object[0]);
                if (n2 == null) break;
                yD2 = (yD)accessible.getAttribute(yc.w, n2);
                break;
            }
            case Q: {
                Integer n3 = (Integer)this.getAttribute(yc.y, new Object[0]);
                if (n3 == null) break;
                yD2 = (yD)accessible.getAttribute(yc.Q, n3);
                break;
            }
            case J: 
            case R: {
                Integer n4 = (Integer)this.getAttribute(yc.S, new Object[0]);
                Integer n5 = (Integer)this.getAttribute(yc.h, new Object[0]);
                if (n4 == null || n5 == null) break;
                yD2 = (yD)accessible.getAttribute(yc.f, n4, n5);
                break;
            }
        }
        if (yD2 != null) {
            accessible.executeAction(yb.h, yD2);
        }
    }

    static {
        WinAccessible._initIDs();
        idCount = 1;
    }
}

