/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.image.PixelUtils;
import dev.protect.RL;
import dev.protect.RW;
import dev.protect.Rl;
import dev.protect.Rm;
import dev.protect.UM;
import dev.protect.abe;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;

public abstract class GlassRobot {
    public static final int MOUSE_LEFT_BTN = 1;
    public static final int MOUSE_RIGHT_BTN = 2;
    public static final int MOUSE_MIDDLE_BTN = 4;
    public static final int MOUSE_BACK_BTN = 8;
    public static final int MOUSE_FORWARD_BTN = 16;

    public abstract void create();

    public abstract void destroy();

    public abstract void keyPress(RL var1);

    public abstract void keyRelease(RL var1);

    public abstract double getMouseX();

    public abstract double getMouseY();

    public abstract void mouseMove(double var1, double var3);

    public abstract void mousePress(RW ... var1);

    public abstract void mouseRelease(RW ... var1);

    public abstract void mouseWheel(int var1);

    public abstract UM getPixelColor(double var1, double var3);

    public void getScreenCapture(int n2, int n3, int n4, int n5, int[] nArray, boolean bl2) {
        throw new InternalError("not implemented");
    }

    public Rm getScreenCapture(Rm rm2, double d2, double d3, double d4, double d5, boolean bl2) {
        int n2;
        int n3;
        int[] nArray;
        int n4 = (int)d4;
        int n5 = (int)d5;
        if (n4 <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (n4 >= Integer.MAX_VALUE / n5) {
            throw new IllegalArgumentException("invalid capture size");
        }
        abe abe2 = abe.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
        Objects.requireNonNull(abe2);
        double d6 = abe2.gI();
        double d7 = abe2.gJ();
        if (d6 == 1.0 && d7 == 1.0) {
            nArray = new int[n4 * n5];
            this.getScreenCapture((int)d2, (int)d3, n4, n5, nArray, bl2);
            n3 = n4;
            n2 = n5;
        } else {
            int n6 = (int)Math.floor(d2 * d6);
            int n7 = (int)Math.floor(d3 * d7);
            int n8 = (int)Math.ceil((d2 + d4) * d6);
            int n9 = (int)Math.ceil((d3 + d5) * d7);
            int n10 = n8 - n6;
            int n11 = n9 - n7;
            if (n10 <= 0) {
                throw new IllegalArgumentException("invalid width");
            }
            if (n11 <= 0) {
                throw new IllegalArgumentException("invalid height");
            }
            if (n10 >= Integer.MAX_VALUE / n11) {
                throw new IllegalArgumentException("invalid capture size");
            }
            int[] nArray2 = new int[n10 * n11];
            this.getScreenCapture(n6, n7, n10, n11, nArray2, bl2);
            n3 = n10;
            n2 = n11;
            if (!bl2) {
                nArray = nArray2;
            } else {
                nArray = new int[n4 * n5];
                int n12 = 0;
                for (int i2 = 0; i2 < n5; ++i2) {
                    double d8 = (d3 + (double)i2 + 0.5) * d7 - (double)((float)n7 + 0.5f);
                    int n13 = (int)Math.floor(d8);
                    int n14 = (int)((d8 - (double)n13) * 256.0);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        double d9 = (d2 + (double)i3 + 0.5) * d6 - (double)((float)n6 + 0.5f);
                        int n15 = (int)Math.floor(d9);
                        int n16 = (int)((d9 - (double)n15) * 256.0);
                        nArray[n12++] = GlassRobot.interp(nArray2, n15, n13, n10, n11, n16, n14);
                    }
                }
                n3 = n4;
                n2 = n5;
            }
        }
        return GlassRobot.convertFromPixels(rm2, Application.GetApplication().createPixels(n3, n2, IntBuffer.wrap(nArray)));
    }

    public static int convertToRobotMouseButton(RW[] rWArray) {
        int n2 = 0;
        block7: for (RW rW2 : rWArray) {
            switch (rW2) {
                case a: {
                    n2 |= 1;
                    continue block7;
                }
                case c: {
                    n2 |= 2;
                    continue block7;
                }
                case b: {
                    n2 |= 4;
                    continue block7;
                }
                case d: {
                    n2 |= 8;
                    continue block7;
                }
                case e: {
                    n2 |= 0x10;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + rW2 + " not supported by Robot");
                }
            }
        }
        return n2;
    }

    public static UM convertFromIntArgb(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        return new UM((double)n4 / 255.0, (double)n5 / 255.0, (double)n6 / 255.0, (double)n3 / 255.0);
    }

    protected static Rm convertFromPixels(Rm rm2, Pixels pixels) {
        int n2;
        Objects.requireNonNull(pixels);
        int n3 = pixels.getWidth();
        int n4 = pixels.getHeight();
        if (rm2 == null || rm2.cS() != (double)n3 || rm2.cT() != (double)n4) {
            rm2 = new Rm(n3, n4);
        }
        if ((n2 = pixels.getBytesPerComponent()) == 4) {
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            GlassRobot.writeIntBufferToImage(intBuffer, rm2);
        } else if (n2 == 1) {
            ByteBuffer byteBuffer = (ByteBuffer)pixels.getPixels();
            GlassRobot.writeByteBufferToImage(byteBuffer, rm2);
        } else {
            throw new IllegalArgumentException("bytesPerComponent must be either 4 or 1 but was: " + n2);
        }
        return rm2;
    }

    private static void writeIntBufferToImage(IntBuffer intBuffer, Rm rm2) {
        Objects.requireNonNull(rm2);
        Rl rl2 = rm2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
        double d2 = rm2.cS();
        double d3 = rm2.cT();
        int n2 = 0;
        while ((double)n2 < d3) {
            int n3 = 0;
            while ((double)n3 < d2) {
                int n4 = intBuffer.get();
                rl2.setArgb(n3, n2, n4);
                ++n3;
            }
            ++n2;
        }
    }

    private static void writeByteBufferToImage(ByteBuffer byteBuffer, Rm rm2) {
        Objects.requireNonNull(rm2);
        Rl rl2 = rm2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
        double d2 = rm2.cS();
        double d3 = rm2.cT();
        int n2 = Pixels.getNativeFormat();
        int n3 = 0;
        while ((double)n3 < d3) {
            int n4 = 0;
            while ((double)n4 < d2) {
                if (n2 == 1) {
                    rl2.setArgb(n4, n3, PixelUtils.PretoNonPre(GlassRobot.bgraPreToRgbaPre(byteBuffer.getInt())));
                } else if (n2 == 2) {
                    rl2.setArgb(n4, n3, byteBuffer.getInt());
                } else {
                    throw new IllegalArgumentException("format must be either BYTE_BGRA_PRE or BYTE_ARGB");
                }
                ++n4;
            }
            ++n3;
        }
    }

    private static int bgraPreToRgbaPre(int n2) {
        return Integer.reverseBytes(n2);
    }

    private static int interp(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = 256 - n6;
        int n10 = 256 - n7;
        int n11 = n3 * n4 + n2;
        int n12 = n8 = n2 < 0 || n3 < 0 || n2 >= n4 || n3 >= n5 ? 0 : nArray[n11];
        if (n7 == 0) {
            if (n6 == 0) {
                return n8;
            }
            int n13 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
            return GlassRobot.interp(n8, n13, n9, n6);
        }
        if (n6 == 0) {
            int n14 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
            return GlassRobot.interp(n8, n14, n10, n7);
        }
        int n15 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
        int n16 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
        int n17 = n2 + 1 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4 + 1];
        return GlassRobot.interp(GlassRobot.interp(n8, n15, n9, n6), GlassRobot.interp(n16, n17, n9, n6), n10, n7);
    }

    private static int interp(int n2, int n3, int n4, int n5) {
        int n6 = n2 >> 24 & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        int n10 = n3 >> 24 & 0xFF;
        int n11 = n3 >> 16 & 0xFF;
        int n12 = n3 >> 8 & 0xFF;
        int n13 = n3 & 0xFF;
        int n14 = n6 * n4 + n10 * n5 >> 8;
        int n15 = n7 * n4 + n11 * n5 >> 8;
        int n16 = n8 * n4 + n12 * n5 >> 8;
        int n17 = n9 * n4 + n13 * n5 >> 8;
        return n14 << 24 | n15 << 16 | n16 << 8 | n17;
    }
}

