/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.SocialInteractionsService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.response.BlockListResponse;
import com.mojang.authlib.yggdrasil.response.PrivilegesResponse;
import java.net.URL;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;

public class YggdrasilSocialInteractionsService
implements SocialInteractionsService {
    private static final long BLOCKLIST_REQUEST_COOLDOWN_SECONDS = 120L;
    private static final UUID ZERO_UUID = new UUID(0L, 0L);
    private final URL routePrivileges;
    private final URL routeBlocklist;
    private final YggdrasilAuthenticationService authenticationService;
    private final String accessToken;
    private boolean serversAllowed;
    private boolean realmsAllowed;
    private boolean chatAllowed;
    private Instant nextAcceptableBlockRequest;
    private Set<UUID> blockList;

    public YggdrasilSocialInteractionsService(YggdrasilAuthenticationService yggdrasilAuthenticationService, String string, Environment environment) {
        this.authenticationService = yggdrasilAuthenticationService;
        this.accessToken = string;
        this.routePrivileges = HttpAuthenticationService.constantURL(environment.getServicesHost() + "/privileges");
        this.routeBlocklist = HttpAuthenticationService.constantURL(environment.getServicesHost() + "/privacy/blocklist");
        this.checkPrivileges();
    }

    @Override
    public boolean serversAllowed() {
        return this.serversAllowed;
    }

    @Override
    public boolean realmsAllowed() {
        return this.realmsAllowed;
    }

    @Override
    public boolean chatAllowed() {
        return this.chatAllowed;
    }

    @Override
    public boolean isBlockedPlayer(UUID uUID) {
        if (uUID.equals(ZERO_UUID)) {
            return false;
        }
        if (this.blockList == null) {
            this.blockList = this.fetchBlockList();
            if (this.blockList == null) {
                return false;
            }
        }
        return this.blockList.contains(uUID);
    }

    private Set<UUID> fetchBlockList() {
        if (this.nextAcceptableBlockRequest != null && this.nextAcceptableBlockRequest.isAfter(Instant.now())) {
            return null;
        }
        this.nextAcceptableBlockRequest = Instant.now().plusSeconds(120L);
        try {
            BlockListResponse blockListResponse = this.authenticationService.makeRequest(this.routeBlocklist, null, BlockListResponse.class, "Bearer " + this.accessToken);
            if (blockListResponse == null) {
                return null;
            }
            return blockListResponse.getBlockedProfiles();
        }
        catch (AuthenticationException authenticationException) {
            return null;
        }
    }

    private void checkPrivileges() {
        PrivilegesResponse privilegesResponse = this.authenticationService.makeRequest(this.routePrivileges, null, PrivilegesResponse.class, "Bearer " + this.accessToken);
        if (privilegesResponse == null) {
            throw new AuthenticationUnavailableException();
        }
        this.chatAllowed = privilegesResponse.getPrivileges().getOnlineChat().isEnabled();
        this.serversAllowed = privilegesResponse.getPrivileges().getMultiplayerServer().isEnabled();
        this.realmsAllowed = privilegesResponse.getPrivileges().getMultiplayerRealms().isEnabled();
    }
}

