/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.BitSet;

final class TypeAdapters$2
extends TypeAdapter<BitSet> {
    TypeAdapters$2() {
    }

    @Override
    public BitSet read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        BitSet bitSet = new BitSet();
        jsonReader.beginArray();
        int n2 = 0;
        JsonToken jsonToken = jsonReader.peek();
        while (jsonToken != JsonToken.END_ARRAY) {
            boolean bl2;
            switch (jsonToken) {
                case NUMBER: {
                    bl2 = jsonReader.nextInt() != 0;
                    break;
                }
                case BOOLEAN: {
                    bl2 = jsonReader.nextBoolean();
                    break;
                }
                case STRING: {
                    String string = jsonReader.nextString();
                    try {
                        bl2 = Integer.parseInt(string) != 0;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JsonSyntaxException("Error: Expecting: bitset number value (1, 0), Found: " + string);
                    }
                }
                default: {
                    throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken));
                }
            }
            if (bl2) {
                bitSet.set(n2);
            }
            ++n2;
            jsonToken = jsonReader.peek();
        }
        jsonReader.endArray();
        return bitSet;
    }

    @Override
    public void write(JsonWriter jsonWriter, BitSet bitSet) {
        if (bitSet == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        for (int i2 = 0; i2 < bitSet.length(); ++i2) {
            int n2 = bitSet.get(i2) ? 1 : 0;
            jsonWriter.value(n2);
        }
        jsonWriter.endArray();
    }
}

