/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

final class MapTypeAdapterFactory$Adapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> keyTypeAdapter;
    private final TypeAdapter<V> valueTypeAdapter;
    private final ObjectConstructor<? extends Map<K, V>> constructor;
    final /* synthetic */ MapTypeAdapterFactory this$0;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
        this.this$0 = mapTypeAdapterFactory;
        this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(gson, typeAdapter, type);
        this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(gson, typeAdapter2, type2);
        this.constructor = objectConstructor;
    }

    @Override
    public Map<K, V> read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Map<K, V> map = this.constructor.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                K k2 = this.keyTypeAdapter.read(jsonReader);
                V v2 = this.valueTypeAdapter.read(jsonReader);
                V v3 = map.put(k2, v2);
                if (v3 != null) {
                    throw new JsonSyntaxException("duplicate key: " + k2);
                }
                jsonReader.endArray();
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                V v4;
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                K k3 = this.keyTypeAdapter.read(jsonReader);
                V v5 = map.put(k3, v4 = this.valueTypeAdapter.read(jsonReader));
                if (v5 == null) continue;
                throw new JsonSyntaxException("duplicate key: " + k3);
            }
            jsonReader.endObject();
        }
        return map;
    }

    @Override
    public void write(JsonWriter jsonWriter, Map<K, V> map) {
        if (map == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!this.this$0.complexMapKeySerialization) {
            jsonWriter.beginObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean bl2 = false;
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(map.size());
        ArrayList<V> arrayList2 = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> object : map.entrySet()) {
            JsonElement jsonElement = this.keyTypeAdapter.toJsonTree(object.getKey());
            arrayList.add(jsonElement);
            arrayList2.add(object.getValue());
            bl2 |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
        }
        if (bl2) {
            jsonWriter.beginArray();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList.get(i2), jsonWriter);
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i2));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
        } else {
            jsonWriter.beginObject();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                JsonElement jsonElement = (JsonElement)arrayList.get(i3);
                jsonWriter.name(this.keyToString(jsonElement));
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i3));
            }
            jsonWriter.endObject();
        }
    }

    private String keyToString(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return String.valueOf(jsonPrimitive.getAsNumber());
            }
            if (jsonPrimitive.isBoolean()) {
                return Boolean.toString(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            throw new AssertionError();
        }
        if (jsonElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }
}

