/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.$Gson$Types$GenericArrayTypeImpl;
import com.google.gson.internal.$Gson$Types$ParameterizedTypeImpl;
import com.google.gson.internal.$Gson$Types$WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
        throw new UnsupportedOperationException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new $Gson$Types$ParameterizedTypeImpl(type, type2, typeArray);
    }

    public static GenericArrayType arrayOf(Type type) {
        return new $Gson$Types$GenericArrayTypeImpl(type);
    }

    public static WildcardType subtypeOf(Type type) {
        return new $Gson$Types$WildcardTypeImpl(new Type[]{type}, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type type) {
        return new $Gson$Types$WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? new $Gson$Types$GenericArrayTypeImpl($Gson$Types.canonicalize(clazz.getComponentType())) : clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new $Gson$Types$ParameterizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new $Gson$Types$GenericArrayTypeImpl(genericArrayType.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new $Gson$Types$WildcardTypeImpl(wildcardType.getUpperBounds(), wildcardType.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            $Gson$Preconditions.checkArgument(type2 instanceof Class);
            return (Class)type2;
        }
        if (type instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance($Gson$Types.getRawType(type3), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return $Gson$Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String string = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string);
    }

    static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static boolean equals(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            return $Gson$Types.equal(parameterizedType.getOwnerType(), parameterizedType2.getOwnerType()) && parameterizedType.getRawType().equals(parameterizedType2.getRawType()) && Arrays.equals(parameterizedType.getActualTypeArguments(), parameterizedType2.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType genericArrayType = (GenericArrayType)type;
            GenericArrayType genericArrayType2 = (GenericArrayType)type2;
            return $Gson$Types.equals(genericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            WildcardType wildcardType = (WildcardType)type;
            WildcardType wildcardType2 = (WildcardType)type2;
            return Arrays.equals(wildcardType.getUpperBounds(), wildcardType2.getUpperBounds()) && Arrays.equals(wildcardType.getLowerBounds(), wildcardType2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            TypeVariable typeVariable = (TypeVariable)type;
            TypeVariable typeVariable2 = (TypeVariable)type2;
            return typeVariable.getGenericDeclaration() == typeVariable2.getGenericDeclaration() && typeVariable.getName().equals(typeVariable2.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static Type getGenericSupertype(Type type, Class<?> object, Class<?> clazz) {
        Object object2;
        if (clazz == object) {
            return type;
        }
        if (clazz.isInterface()) {
            object2 = ((Class)object).getInterfaces();
            int n2 = ((Class<?>[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object2[i2] == clazz) {
                    return ((Class)object).getGenericInterfaces()[i2];
                }
                if (!clazz.isAssignableFrom(object2[i2])) continue;
                return $Gson$Types.getGenericSupertype(((Class)object).getGenericInterfaces()[i2], object2[i2], clazz);
            }
        }
        if (!((Class)object).isInterface()) {
            while (object != Object.class) {
                object2 = ((Class)object).getSuperclass();
                if (object2 == clazz) {
                    return ((Class)object).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object2)) {
                    return $Gson$Types.getGenericSupertype(((Class)object).getGenericSuperclass(), object2, clazz);
                }
                object = object2;
            }
        }
        return clazz;
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.getGenericSupertype(type, clazz, clazz2));
    }

    public static Type getArrayComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
    }

    public static Type getCollectionElementType(Type type, Class<?> clazz) {
        Type type2 = $Gson$Types.getSupertype(type, clazz, Collection.class);
        if (type2 instanceof WildcardType) {
            type2 = ((WildcardType)type2).getUpperBounds()[0];
        }
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        Type type2 = $Gson$Types.getSupertype(type, clazz, Map.class);
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            return parameterizedType.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        Type type3;
        while (type2 instanceof TypeVariable) {
            type3 = (TypeVariable)type2;
            if ((type2 = $Gson$Types.resolveTypeVariable(type, clazz, type3)) != type3) continue;
            return type2;
        }
        if (type2 instanceof Class && ((Class)type2).isArray()) {
            Type type4;
            type3 = (Class)type2;
            Class<?> clazz2 = ((Class)type3).getComponentType();
            return clazz2 == (type4 = $Gson$Types.resolve(type, clazz, clazz2)) ? type3 : $Gson$Types.arrayOf(type4);
        }
        if (type2 instanceof GenericArrayType) {
            Type type5;
            type3 = (GenericArrayType)type2;
            Type type6 = type3.getGenericComponentType();
            return type6 == (type5 = $Gson$Types.resolve(type, clazz, type6)) ? type3 : $Gson$Types.arrayOf(type5);
        }
        if (type2 instanceof ParameterizedType) {
            type3 = (ParameterizedType)type2;
            Type type7 = type3.getOwnerType();
            Type type8 = $Gson$Types.resolve(type, clazz, type7);
            boolean bl2 = type8 != type7;
            Type[] typeArray = type3.getActualTypeArguments();
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type9 = $Gson$Types.resolve(type, clazz, typeArray[i2]);
                if (type9 == typeArray[i2]) continue;
                if (!bl2) {
                    typeArray = (Type[])typeArray.clone();
                    bl2 = true;
                }
                typeArray[i2] = type9;
            }
            return bl2 ? $Gson$Types.newParameterizedTypeWithOwner(type8, type3.getRawType(), typeArray) : type3;
        }
        if (type2 instanceof WildcardType) {
            Type type10;
            type3 = (WildcardType)type2;
            Type[] typeArray = type3.getLowerBounds();
            Type[] typeArray2 = type3.getUpperBounds();
            if (typeArray.length == 1) {
                Type type11 = $Gson$Types.resolve(type, clazz, typeArray[0]);
                if (type11 != typeArray[0]) {
                    return $Gson$Types.supertypeOf(type11);
                }
            } else if (typeArray2.length == 1 && (type10 = $Gson$Types.resolve(type, clazz, typeArray2[0])) != typeArray2[0]) {
                return $Gson$Types.subtypeOf(type10);
            }
            return type3;
        }
        return type2;
    }

    static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = $Gson$Types.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        Type type2 = $Gson$Types.getGenericSupertype(type, clazz, clazz2);
        if (type2 instanceof ParameterizedType) {
            int n2 = $Gson$Types.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type2).getActualTypeArguments()[n2];
        }
        return typeVariable;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!object.equals(objectArray[i2])) continue;
            return i2;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        return obj instanceof Class ? (Class)obj : null;
    }

    static void checkNotPrimitive(Type type) {
        $Gson$Preconditions.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }
}

