/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.X;
import com.google.common.collect.er;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public interface ec<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(@CompatibleWith(value="K") Object var1);

    public boolean containsValue(@CompatibleWith(value="V") Object var1);

    public boolean containsEntry(@CompatibleWith(value="K") Object var1, @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean put(K var1, V var2);

    @CanIgnoreReturnValue
    public boolean remove(@CompatibleWith(value="K") Object var1, @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean putAll(K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public boolean putAll(ec<? extends K, ? extends V> var1);

    @CanIgnoreReturnValue
    public Collection<V> replaceValues(K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public Collection<V> removeAll(@CompatibleWith(value="K") Object var1);

    public void clear();

    public Collection<V> get(K var1);

    public Set<K> keySet();

    public er<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        X.checkNotNull(biConsumer);
        this.entries().forEach((? super T entry) -> biConsumer.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(Object var1);

    public int hashCode();
}

